/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.TabListHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.tablist.GlobalPingTabList;
import net.md_5.bungee.tablist.GlobalTabList;
import net.md_5.bungee.tablist.ServerUniqueTabList;

public class Configuration {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private Map<String, ServerInfo> servers;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        DefaultTabList tab = DefaultTabList.valueOf(adapter.getString("tab_list", "GLOBAL_PING"));
        if (tab == null) {
            tab = DefaultTabList.GLOBAL_PING;
        }
        switch (tab) {
            case GLOBAL: {
                ProxyServer.getInstance().setTabListHandler((TabListHandler)new GlobalTabList());
                break;
            }
            case GLOBAL_PING: {
                ProxyServer.getInstance().setTabListHandler((TabListHandler)new GlobalPingTabList());
                break;
            }
            case SERVER: {
                ProxyServer.getInstance().setTabListHandler((TabListHandler)new ServerUniqueTabList());
            }
        }
        this.listeners = adapter.getListeners();
        Preconditions.checkArgument((this.listeners != null && !this.listeners.isEmpty() ? 1 : 0) != 0, (Object)"No listeners defined.");
        this.servers = adapter.getServers();
        Preconditions.checkArgument((this.servers != null && !this.servers.isEmpty() ? 1 : 0) != 0, (Object)"No servers defined");
        for (ListenerInfo listener : this.listeners) {
            Preconditions.checkArgument((boolean)this.servers.containsKey(listener.getDefaultServer()));
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public Map<String, ServerInfo> getServers() {
        return this.servers;
    }

    private static enum DefaultTabList {
        GLOBAL,
        GLOBAL_PING,
        SERVER;

    }
}

