/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.scheduler.BungeeTask;

public class BungeeScheduler
implements TaskScheduler {
    private final Object lock = new Object();
    private final AtomicInteger taskCounter = new AtomicInteger();
    private final TIntObjectMap<BungeeTask> tasks = TCollections.synchronizedMap(new TIntObjectHashMap());
    private final Multimap<Plugin, BungeeTask> tasksByPlugin = Multimaps.synchronizedMultimap(HashMultimap.create());
    private final TaskScheduler.Unsafe unsafe = new TaskScheduler.Unsafe(){

        @Override
        public ExecutorService getExecutorService(Plugin plugin) {
            return plugin.getExecutorService();
        }
    };

    @Override
    public void cancel(int id) {
        BungeeTask task = this.tasks.get(id);
        Preconditions.checkArgument(task != null, "No task with id %s", id);
        task.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel0(BungeeTask task) {
        Object object = this.lock;
        synchronized (object) {
            this.tasks.remove(task.getId());
            this.tasksByPlugin.values().remove(task);
        }
    }

    @Override
    public void cancel(ScheduledTask task) {
        task.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancel(Plugin plugin) {
        HashSet<ScheduledTask> toRemove = new HashSet<ScheduledTask>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (ScheduledTask scheduledTask : this.tasksByPlugin.get(plugin)) {
                toRemove.add(scheduledTask);
            }
        }
        for (ScheduledTask task : toRemove) {
            this.cancel(task);
        }
        return toRemove.size();
    }

    @Override
    public ScheduledTask runAsync(Plugin owner, Runnable task) {
        return this.schedule(owner, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, TimeUnit unit) {
        return this.schedule(owner, task, delay, 0L, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(owner, "owner");
        Preconditions.checkNotNull(task, "task");
        BungeeTask prepared = new BungeeTask(this, this.taskCounter.getAndIncrement(), owner, task, delay, period, unit);
        Object object = this.lock;
        synchronized (object) {
            this.tasks.put(prepared.getId(), prepared);
            this.tasksByPlugin.put(owner, prepared);
        }
        owner.getExecutorService().execute(prepared);
        return prepared;
    }

    @Override
    public TaskScheduler.Unsafe unsafe() {
        return this.unsafe;
    }
}

