/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ServerData
extends DefinedPacket {
    private String motd;
    private String icon;
    private boolean preview;
    private boolean enforceSecure;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (buf.readBoolean()) {
            this.motd = ServerData.readString(buf, 262144);
        }
        if (buf.readBoolean()) {
            this.icon = ServerData.readString(buf);
        }
        if (protocolVersion < 761) {
            this.preview = buf.readBoolean();
        }
        if (protocolVersion >= 760) {
            this.enforceSecure = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (this.motd != null) {
            buf.writeBoolean(true);
            ServerData.writeString(this.motd, buf, 262144);
        } else {
            buf.writeBoolean(false);
        }
        if (this.icon != null) {
            buf.writeBoolean(true);
            ServerData.writeString(this.icon, buf);
        } else {
            buf.writeBoolean(false);
        }
        if (protocolVersion < 761) {
            buf.writeBoolean(this.preview);
        }
        if (protocolVersion >= 760) {
            buf.writeBoolean(this.enforceSecure);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getMotd() {
        return this.motd;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isEnforceSecure() {
        return this.enforceSecure;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setEnforceSecure(boolean enforceSecure) {
        this.enforceSecure = enforceSecure;
    }

    @Override
    public String toString() {
        return "ServerData(motd=" + this.getMotd() + ", icon=" + this.getIcon() + ", preview=" + this.isPreview() + ", enforceSecure=" + this.isEnforceSecure() + ")";
    }

    public ServerData() {
    }

    public ServerData(String motd, String icon, boolean preview, boolean enforceSecure) {
        this.motd = motd;
        this.icon = icon;
        this.preview = preview;
        this.enforceSecure = enforceSecure;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerData)) {
            return false;
        }
        ServerData other = (ServerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreview() != other.isPreview()) {
            return false;
        }
        if (this.isEnforceSecure() != other.isEnforceSecure()) {
            return false;
        }
        String this$motd = this.getMotd();
        String other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        return !(this$icon == null ? other$icon != null : !this$icon.equals(other$icon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreview() ? 79 : 97);
        result = result * 59 + (this.isEnforceSecure() ? 79 : 97);
        String $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        return result;
    }
}

