/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class ShortTag
extends SpecificTag {
    public final short value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new ShortTag(in.readShort());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Short:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.getData());
    }

    public ShortTag(short value) {
        this.value = value;
    }

    public short getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Short";
    }

    @Override
    public String tagName() {
        return "TAG_Short";
    }

    @Override
    public int tagType() {
        return 2;
    }

    @Override
    public boolean boolValue() {
        return this.getData() != 0;
    }

    @Override
    public boolean boolValue(boolean defaultValue) {
        return this.getData() != 0;
    }

    @Override
    public short shortValue() {
        return this.getData();
    }

    @Override
    public short shortValue(short defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ShortTag && ((ShortTag)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

