/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientSettings
extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private int chatFlags;
    private boolean chatColours;
    private byte difficulty;
    private byte skinParts;
    private int mainHand;
    private boolean disableTextFiltering;
    private boolean allowServerListing;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.locale = ClientSettings.readString(buf, 16);
        this.viewDistance = buf.readByte();
        this.chatFlags = protocolVersion >= 107 ? DefinedPacket.readVarInt(buf) : (int)buf.readUnsignedByte();
        this.chatColours = buf.readBoolean();
        this.skinParts = buf.readByte();
        if (protocolVersion >= 107) {
            this.mainHand = DefinedPacket.readVarInt(buf);
        }
        if (protocolVersion >= 755) {
            this.disableTextFiltering = buf.readBoolean();
        }
        if (protocolVersion >= 1073741877) {
            this.allowServerListing = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientSettings.writeString(this.locale, buf);
        buf.writeByte(this.viewDistance);
        if (protocolVersion >= 107) {
            DefinedPacket.writeVarInt(this.chatFlags, buf);
        } else {
            buf.writeByte(this.chatFlags);
        }
        buf.writeBoolean(this.chatColours);
        buf.writeByte(this.skinParts);
        if (protocolVersion >= 107) {
            DefinedPacket.writeVarInt(this.mainHand, buf);
        }
        if (protocolVersion >= 755) {
            buf.writeBoolean(this.disableTextFiltering);
        }
        if (protocolVersion >= 1073741877) {
            buf.writeBoolean(this.allowServerListing);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public int getChatFlags() {
        return this.chatFlags;
    }

    public boolean isChatColours() {
        return this.chatColours;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public byte getSkinParts() {
        return this.skinParts;
    }

    public int getMainHand() {
        return this.mainHand;
    }

    public boolean isDisableTextFiltering() {
        return this.disableTextFiltering;
    }

    public boolean isAllowServerListing() {
        return this.allowServerListing;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setChatFlags(int chatFlags) {
        this.chatFlags = chatFlags;
    }

    public void setChatColours(boolean chatColours) {
        this.chatColours = chatColours;
    }

    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    public void setSkinParts(byte skinParts) {
        this.skinParts = skinParts;
    }

    public void setMainHand(int mainHand) {
        this.mainHand = mainHand;
    }

    public void setDisableTextFiltering(boolean disableTextFiltering) {
        this.disableTextFiltering = disableTextFiltering;
    }

    public void setAllowServerListing(boolean allowServerListing) {
        this.allowServerListing = allowServerListing;
    }

    @Override
    public String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", chatColours=" + this.isChatColours() + ", difficulty=" + this.getDifficulty() + ", skinParts=" + this.getSkinParts() + ", mainHand=" + this.getMainHand() + ", disableTextFiltering=" + this.isDisableTextFiltering() + ", allowServerListing=" + this.isAllowServerListing() + ")";
    }

    public ClientSettings() {
    }

    public ClientSettings(String locale, byte viewDistance, int chatFlags, boolean chatColours, byte difficulty, byte skinParts, int mainHand, boolean disableTextFiltering, boolean allowServerListing) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.chatColours = chatColours;
        this.difficulty = difficulty;
        this.skinParts = skinParts;
        this.mainHand = mainHand;
        this.disableTextFiltering = disableTextFiltering;
        this.allowServerListing = allowServerListing;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSettings)) {
            return false;
        }
        ClientSettings other = (ClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getChatFlags() != other.getChatFlags()) {
            return false;
        }
        if (this.isChatColours() != other.isChatColours()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getSkinParts() != other.getSkinParts()) {
            return false;
        }
        if (this.getMainHand() != other.getMainHand()) {
            return false;
        }
        if (this.isDisableTextFiltering() != other.isDisableTextFiltering()) {
            return false;
        }
        if (this.isAllowServerListing() != other.isAllowServerListing()) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        return !(this$locale == null ? other$locale != null : !this$locale.equals(other$locale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientSettings;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getChatFlags();
        result = result * 59 + (this.isChatColours() ? 79 : 97);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getSkinParts();
        result = result * 59 + this.getMainHand();
        result = result * 59 + (this.isDisableTextFiltering() ? 79 : 97);
        result = result * 59 + (this.isAllowServerListing() ? 79 : 97);
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        return result;
    }
}

