/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.module.JenkinsModuleSource;
import net.md_5.bungee.module.ModuleSource;
import net.md_5.bungee.module.ModuleSpec;
import net.md_5.bungee.module.ModuleVersion;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ModuleManager {
    private final Map<String, ModuleSource> knownSources = new HashMap<String, ModuleSource>();

    public ModuleManager() {
        this.knownSources.put("jenkins", new JenkinsModuleSource());
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH", "SF_SWITCH_NO_DEFAULT"})
    public void load(ProxyServer proxy, File moduleDirectory) throws Exception {
        CaseInsensitiveMap<Serializable> config;
        moduleDirectory.mkdir();
        ModuleVersion bungeeVersion = ModuleVersion.parse(proxy.getVersion());
        if (bungeeVersion == null) {
            System.out.println("Couldn't detect bungee version. Custom build?");
            return;
        }
        ArrayList<ModuleSpec> modules = new ArrayList<ModuleSpec>();
        File configFile = new File("modules.yml");
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        configFile.createNewFile();
        try (FileInputStream is = new FileInputStream(configFile);){
            config = (CaseInsensitiveMap<Serializable>)yaml.load(is);
        }
        config = config == null ? new CaseInsensitiveMap<Serializable>() : new CaseInsensitiveMap(config);
        ArrayList<String> defaults = new ArrayList<String>();
        Object readModules = config.get("modules");
        if (readModules != null) {
            defaults.addAll((Collection)readModules);
        }
        int version = config.containsKey("version") ? (Integer)config.get("version") : 0;
        switch (version) {
            case 0: {
                defaults.add("jenkins://cmd_alert");
                defaults.add("jenkins://cmd_find");
                defaults.add("jenkins://cmd_list");
                defaults.add("jenkins://cmd_send");
                defaults.add("jenkins://cmd_server");
            }
            case 1: {
                defaults.add("jenkins://reconnect_yaml");
            }
        }
        config.put("modules", defaults);
        config.put("version", Integer.valueOf(2));
        try (FileWriter wr = new FileWriter(configFile);){
            yaml.dump(config, wr);
        }
        for (String s : (List)config.get("modules")) {
            URI uri = new URI(s);
            ModuleSource source = this.knownSources.get(uri.getScheme());
            if (source == null) {
                System.out.println("Unknown module source: " + s);
                continue;
            }
            String name = uri.getAuthority();
            if (name == null) {
                System.out.println("Unknown module host: " + s);
                continue;
            }
            ModuleSpec spec = new ModuleSpec(name, new File(moduleDirectory, name + ".jar"), source);
            modules.add(spec);
            System.out.println("Discovered module: " + spec);
        }
        for (ModuleSpec module : modules) {
            ModuleVersion moduleVersion = module.getFile().exists() ? this.getVersion(module.getFile()) : null;
            if (bungeeVersion.equals(moduleVersion)) continue;
            System.out.println("Attempting to update plugin from " + moduleVersion + " to " + bungeeVersion);
            module.getProvider().retrieve(module, bungeeVersion);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private ModuleVersion getVersion(File file) {
        try (JarFile jar = new JarFile(file);){
            ModuleVersion moduleVersion;
            block13: {
                JarEntry pdf = jar.getJarEntry("plugin.yml");
                Preconditions.checkNotNull(pdf, "Plugin must have a plugin.yml");
                InputStream in = jar.getInputStream(pdf);
                try {
                    PluginDescription desc = new Yaml().loadAs(in, PluginDescription.class);
                    moduleVersion = ModuleVersion.parse(desc.getVersion());
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return moduleVersion;
        }
        catch (Exception ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not check module from file " + file, ex);
            return null;
        }
    }
}

