/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;

public class JsonConfiguration
extends ConfigurationProvider {
    private final Gson json = new GsonBuilder().serializeNulls().setPrettyPrinting().registerTypeAdapter((Type)((Object)Configuration.class), new JsonSerializer<Configuration>(){

        @Override
        public JsonElement serialize(Configuration src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(src.self);
        }
    }).create();

    @Override
    public void save(Configuration config, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            this.save(config, writer);
        }
    }

    @Override
    public void save(Configuration config, Writer writer) {
        this.json.toJson(config.self, (Appendable)writer);
    }

    @Override
    public Configuration load(File file) throws IOException {
        return this.load(file, null);
    }

    @Override
    public Configuration load(File file, Configuration defaults) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Configuration configuration = this.load(is, defaults);
            return configuration;
        }
    }

    @Override
    public Configuration load(Reader reader) {
        return this.load(reader, null);
    }

    @Override
    public Configuration load(Reader reader, Configuration defaults) {
        LinkedHashMap map = this.json.fromJson(reader, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    @Override
    public Configuration load(InputStream is) {
        return this.load(is, null);
    }

    @Override
    public Configuration load(InputStream is, Configuration defaults) {
        return this.load(new InputStreamReader(is, Charsets.UTF_8), defaults);
    }

    @Override
    public Configuration load(String string) {
        return this.load(string, null);
    }

    @Override
    public Configuration load(String string, Configuration defaults) {
        LinkedHashMap map = this.json.fromJson(string, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    JsonConfiguration() {
    }
}

