/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class LongTag
extends SpecificTag {
    public final long value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new LongTag(in.readLong());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Long:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.getData());
    }

    public LongTag(long value) {
        this.value = value;
    }

    public long getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Long";
    }

    @Override
    public String tagName() {
        return "TAG_Long";
    }

    @Override
    public int tagType() {
        return 4;
    }

    @Override
    public boolean boolValue() {
        return this.getData() != 0L;
    }

    @Override
    public boolean boolValue(boolean defaultValue) {
        return this.getData() != 0L;
    }

    @Override
    public long longValue() {
        return this.getData();
    }

    @Override
    public long longValue(long defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LongTag && ((LongTag)obj).value == this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

