/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;

public final class ItemTag {
    private final String nbt;
    private BaseComponent name;
    private List<Enchantment> enchantments;
    private List<BaseComponent[]> lore;
    private Boolean unbreakable;

    private ItemTag(String nbt) {
        this.nbt = nbt;
    }

    public static ItemTag ofNbt(String nbt) {
        return new ItemTag(nbt);
    }

    private static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ItemTag(nbt=" + this.getNbt() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemTag)) {
            return false;
        }
        ItemTag other = (ItemTag)o;
        String this$nbt = this.getNbt();
        String other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public void setName(BaseComponent name) {
        this.name = name;
    }

    public void setEnchantments(List<Enchantment> enchantments) {
        this.enchantments = enchantments;
    }

    public void setLore(List<BaseComponent[]> lore) {
        this.lore = lore;
    }

    public void setUnbreakable(Boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public ItemTag(String nbt, BaseComponent name, List<Enchantment> enchantments, List<BaseComponent[]> lore, Boolean unbreakable) {
        this.nbt = nbt;
        this.name = name;
        this.enchantments = enchantments;
        this.lore = lore;
        this.unbreakable = unbreakable;
    }

    public String getNbt() {
        return this.nbt;
    }

    private static class Builder {
        private String nbt;
        private BaseComponent name;
        private ArrayList<Enchantment> enchantments;
        private ArrayList<BaseComponent[]> lore;
        private Boolean unbreakable;

        Builder() {
        }

        private Builder nbt(String nbt) {
            this.nbt = nbt;
            return this;
        }

        private Builder name(BaseComponent name) {
            this.name = name;
            return this;
        }

        private Builder ench(Enchantment ench) {
            if (this.enchantments == null) {
                this.enchantments = new ArrayList();
            }
            this.enchantments.add(ench);
            return this;
        }

        private Builder enchantments(Collection<? extends Enchantment> enchantments) {
            if (this.enchantments == null) {
                this.enchantments = new ArrayList();
            }
            this.enchantments.addAll(enchantments);
            return this;
        }

        private Builder clearEnchantments() {
            if (this.enchantments != null) {
                this.enchantments.clear();
            }
            return this;
        }

        private Builder lore(BaseComponent[] lore) {
            if (this.lore == null) {
                this.lore = new ArrayList();
            }
            this.lore.add(lore);
            return this;
        }

        private Builder lore(Collection<? extends BaseComponent[]> lore) {
            if (this.lore == null) {
                this.lore = new ArrayList();
            }
            this.lore.addAll(lore);
            return this;
        }

        private Builder clearLore() {
            if (this.lore != null) {
                this.lore.clear();
            }
            return this;
        }

        private Builder unbreakable(Boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        private ItemTag build() {
            List<BaseComponent[]> lore;
            List<Enchantment> enchantments;
            switch (this.enchantments == null ? 0 : this.enchantments.size()) {
                case 0: {
                    enchantments = Collections.emptyList();
                    break;
                }
                case 1: {
                    enchantments = Collections.singletonList(this.enchantments.get(0));
                    break;
                }
                default: {
                    enchantments = Collections.unmodifiableList(new ArrayList<Enchantment>(this.enchantments));
                }
            }
            switch (this.lore == null ? 0 : this.lore.size()) {
                case 0: {
                    lore = Collections.emptyList();
                    break;
                }
                case 1: {
                    lore = Collections.singletonList(this.lore.get(0));
                    break;
                }
                default: {
                    lore = Collections.unmodifiableList(new ArrayList<BaseComponent[]>(this.lore));
                }
            }
            return new ItemTag(this.nbt, this.name, enchantments, lore, this.unbreakable);
        }

        public String toString() {
            return "ItemTag.Builder(nbt=" + this.nbt + ", name=" + this.name + ", enchantments=" + this.enchantments + ", lore=" + this.lore + ", unbreakable=" + this.unbreakable + ")";
        }
    }

    public static class Serializer
    implements JsonSerializer<ItemTag>,
    JsonDeserializer<ItemTag> {
        @Override
        public ItemTag deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ItemTag.ofNbt(element.toString().replace("\"", ""));
        }

        @Override
        public JsonElement serialize(ItemTag itemTag, Type type, JsonSerializationContext context) {
            return context.serialize(itemTag.getNbt());
        }
    }

    public static class Enchantment {
        private final int level;
        private final int id;

        public Enchantment(int level, int id) {
            this.level = level;
            this.id = id;
        }
    }
}

