/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.forge.ForgeUtils;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.ViewDistance;
import net.md_5.bungee.util.BufUtil;
import net.md_5.bungee.util.QuietException;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.LOGIN_SUCCESS;
    private ForgeServerHandler handshakeHandler;
    private boolean obsolete;

    @Override
    public void exception(Throwable t) throws Exception {
        if (this.obsolete) {
            return;
        }
        String message = "Exception Connecting:" + Util.exception(t);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(ChatColor.RED + message);
        }
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
        this.handshakeHandler = new ForgeServerHandler(this.user, this.ch, this.target);
        Handshake originalHandshake = this.user.getPendingConnection().getHandshake();
        Handshake copiedHandshake = new Handshake(originalHandshake.getProtocolVersion(), originalHandshake.getHost(), originalHandshake.getPort(), 2);
        if (BungeeCord.getInstance().config.isIpForward() && this.user.getSocketAddress() instanceof InetSocketAddress) {
            String newHost = copiedHandshake.getHost() + "\u0000" + this.user.getAddress().getHostString() + "\u0000" + this.user.getUUID();
            LoginResult profile = this.user.getPendingConnection().getLoginProfile();
            if (profile != null && profile.getProperties() != null && profile.getProperties().length > 0) {
                newHost = newHost + "\u0000" + BungeeCord.getInstance().gson.toJson(profile.getProperties());
            }
            copiedHandshake.setHost(newHost);
        } else if (!this.user.getExtraDataInHandshake().isEmpty()) {
            copiedHandshake.setHost(copiedHandshake.getHost() + this.user.getExtraDataInHandshake());
        }
        channel.write(copiedHandshake);
        channel.setProtocol(Protocol.LOGIN);
        channel.write(new LoginRequest(this.user.getName()));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (packet.packet == null) {
            throw new QuietException("Unexpected packet received during server login process!\n" + BufUtil.dump(packet.buf, 16));
        }
    }

    @Override
    public void handle(LoginSuccess loginSuccess) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN_SUCCESS, "Not expecting LOGIN_SUCCESS");
        this.ch.setProtocol(Protocol.GAME);
        this.thisState = State.LOGIN;
        if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete() && this.user.getServer().isForgeServer()) {
            this.user.getForgeClientHandler().resetHandshake();
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(SetCompression setCompression) throws Exception {
        this.ch.setCompressionThreshold(setCompression.getThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target);
        ServerConnectedEvent event = new ServerConnectedEvent(this.user, server);
        this.bungee.getPluginManager().callEvent(event);
        this.ch.write(BungeeCord.getInstance().registerChannels(this.user.getPendingConnection().getVersion()));
        Queue<DefinedPacket> packetQueue = this.target.getPacketQueue();
        Queue<DefinedPacket> queue = packetQueue;
        synchronized (queue) {
            while (!packetQueue.isEmpty()) {
                this.ch.write(packetQueue.poll());
            }
        }
        for (PluginMessage message : this.user.getPendingConnection().getRelayMessages()) {
            this.ch.write(message);
        }
        if (this.user.getSettings() != null) {
            this.ch.write(this.user.getSettings());
        }
        if (this.user.getForgeClientHandler().getClientModList() == null && !this.user.getForgeClientHandler().isHandshakeComplete()) {
            this.user.getForgeClientHandler().setHandshakeComplete();
        }
        if (this.user.getServer() == null) {
            this.user.setClientEntityId(login.getEntityId());
            this.user.setServerEntityId(login.getEntityId());
            Login modLogin = new Login(login.getEntityId(), login.getGameMode(), login.getPreviousGameMode(), login.getWorldNames(), login.getDimensions(), login.getDimension(), login.getWorldName(), login.getSeed(), login.getDifficulty(), (byte)this.user.getPendingConnection().getListener().getTabListSize(), login.getLevelType(), login.getViewDistance(), login.isReducedDebugInfo(), login.isNormalRespawn(), login.isDebug(), login.isFlat());
            this.user.unsafe().sendPacket(modLogin);
            ByteBuf brand = ByteBufAllocator.DEFAULT.heapBuffer();
            DefinedPacket.writeString(this.bungee.getName() + " (" + this.bungee.getVersion() + ")", brand);
            this.user.unsafe().sendPacket(new PluginMessage(this.user.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand", DefinedPacket.toArray(brand), this.handshakeHandler.isServerForge()));
            brand.release();
            this.user.setDimension(login.getDimension());
        } else {
            this.user.getServer().setObsolete(true);
            this.user.getTabListHandler().onServerChange();
            Scoreboard serverScoreboard = this.user.getServerSentScoreboard();
            for (Objective objective : serverScoreboard.getObjectives()) {
                this.user.unsafe().sendPacket(new ScoreboardObjective(objective.getName(), objective.getValue(), ScoreboardObjective.HealthDisplay.fromString(objective.getType()), 1));
            }
            for (Score score : serverScoreboard.getScores()) {
                this.user.unsafe().sendPacket(new ScoreboardScore(score.getItemName(), 1, score.getScoreName(), score.getValue()));
            }
            for (net.md_5.bungee.api.score.Team team : serverScoreboard.getTeams()) {
                this.user.unsafe().sendPacket(new Team(team.getName()));
            }
            serverScoreboard.clear();
            for (UUID bossbar : this.user.getSentBossBars()) {
                this.user.unsafe().sendPacket(new BossBar(bossbar, 1));
            }
            this.user.getSentBossBars().clear();
            this.user.unsafe().sendPacket(new EntityStatus(this.user.getClientEntityId(), login.isReducedDebugInfo() ? (byte)22 : 23));
            if (this.user.getPendingConnection().getVersion() >= 573) {
                this.user.unsafe().sendPacket(new GameState(11, login.isNormalRespawn() ? 0.0f : 1.0f));
            }
            this.user.setDimensionChange(true);
            if (login.getDimension().equals(this.user.getDimension())) {
                Object newDim;
                String worldName = login.getWorldName();
                if (login.getDimension() instanceof Number) {
                    newDim = ((Number)login.getDimension()).intValue() >= 0 ? -1 : 0;
                } else {
                    worldName = "minecraft:overworld".equals(login.getDimension()) ? "minecraft:the_nether" : "minecraft:overworld";
                    newDim = worldName;
                }
                this.user.unsafe().sendPacket(new Respawn(newDim, worldName, login.getSeed(), login.getDifficulty(), login.getGameMode(), login.getPreviousGameMode(), login.getLevelType(), login.isDebug(), login.isFlat(), false));
            }
            this.user.setServerEntityId(login.getEntityId());
            this.user.unsafe().sendPacket(new Respawn(login.getDimension(), login.getWorldName(), login.getSeed(), login.getDifficulty(), login.getGameMode(), login.getPreviousGameMode(), login.getLevelType(), login.isDebug(), login.isFlat(), false));
            if (this.user.getPendingConnection().getVersion() >= 477) {
                this.user.unsafe().sendPacket(new ViewDistance(login.getViewDistance()));
            }
            this.user.setDimension(login.getDimension());
            this.user.getServer().disconnect("Quitting");
        }
        if (!this.user.isActive()) {
            server.disconnect("Quitting");
            this.bungee.getLogger().warning("No client connected for pending server!");
            return;
        }
        this.target.addPlayer(this.user);
        this.user.getPendingConnects().remove(this.target);
        this.user.setServerJoinQueue(null);
        this.user.setDimensionChange(false);
        BungeeServerInfo from = this.user.getServer() == null ? null : this.user.getServer().getInfo();
        this.user.setServer(server);
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(this.bungee, this.user, server));
        this.bungee.getPluginManager().callEvent(new ServerSwitchEvent(this.user, from));
        this.thisState = State.FINISHED;
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(EncryptionRequest encryptionRequest) throws Exception {
        throw new QuietException("Server is online mode!");
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerInfo def = this.user.updateAndGetNextServer(this.target);
        ServerKickEvent event = new ServerKickEvent(this.user, this.target, ComponentSerializer.parse(kick.getMessage()), def, ServerKickEvent.State.CONNECTING);
        if (event.getKickReason().toLowerCase(Locale.ROOT).contains("outdated") && def != null) {
            event.setCancelled(true);
        }
        this.bungee.getPluginManager().callEvent(event);
        if (event.isCancelled() && event.getCancelServer() != null) {
            this.obsolete = true;
            this.user.connect(event.getCancelServer(), ServerConnectEvent.Reason.KICK_REDIRECT);
            throw CancelSendSignal.INSTANCE;
        }
        String message = this.bungee.getTranslation("connect_kick", this.target.getName(), event.getKickReason());
        if (this.user.isDimensionChange()) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (BungeeCord.getInstance().config.isForgeSupport()) {
            if (pluginMessage.getTag().equals("REGISTER")) {
                Set<String> channels = ForgeUtils.readRegisteredChannels(pluginMessage);
                boolean isForgeServer = false;
                for (String channel : channels) {
                    if (!channel.equals("FML|HS")) continue;
                    if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete()) {
                        this.user.getForgeClientHandler().resetHandshake();
                    }
                    isForgeServer = true;
                    break;
                }
                if (isForgeServer && !this.handshakeHandler.isServerForge()) {
                    this.handshakeHandler.setServerAsForgeServer();
                    this.user.setForgeServerHandler(this.handshakeHandler);
                }
            }
            if (pluginMessage.getTag().equals("FML|HS") || pluginMessage.getTag().equals("FORGE")) {
                this.handshakeHandler.handle(pluginMessage);
                throw CancelSendSignal.INSTANCE;
            }
        }
        this.user.unsafe().sendPacket(pluginMessage);
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    public ServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    public ForgeServerHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    private static enum State {
        LOGIN_SUCCESS,
        ENCRYPT_RESPONSE,
        LOGIN,
        FINISHED;

    }
}

