/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.packet;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.md_5.mendax.datainput.DataInputPacketReader;

public class PacketInputStream
implements AutoCloseable {
    private final DataInputStream dataInput;
    private final TrackingInputStream tracker;
    private final byte[] buffer = new byte[262144];

    public PacketInputStream(InputStream in) {
        this.tracker = new TrackingInputStream(in);
        this.dataInput = new DataInputStream(this.tracker);
    }

    public byte[] readPacket() throws IOException {
        this.tracker.out.reset();
        DataInputPacketReader.readPacket(this.dataInput, this.buffer);
        return this.tracker.out.toByteArray();
    }

    @Override
    public void close() throws Exception {
        this.dataInput.close();
    }

    private class TrackingInputStream
    extends FilterInputStream {
        private final ByteArrayOutputStream out;

        public TrackingInputStream(InputStream in) {
            super(in);
            this.out = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int ret = this.in.read();
            this.out.write(ret);
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret = this.in.read(b, off, len);
            this.out.write(b, off, ret);
            return ret;
        }
    }
}

