/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeCache;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.GenLayer;
import net.minecraft.server.IntCache;
import net.minecraft.server.World;
import net.minecraft.server.WorldType;

public class WorldChunkManager {
    private GenLayer d;
    private GenLayer e;
    private BiomeCache f = new BiomeCache(this);
    private List g = new ArrayList();

    protected WorldChunkManager() {
        this.g.add(BiomeBase.FOREST);
        this.g.add(BiomeBase.PLAINS);
        this.g.add(BiomeBase.TAIGA);
        this.g.add(BiomeBase.TAIGA_HILLS);
        this.g.add(BiomeBase.FOREST_HILLS);
        this.g.add(BiomeBase.JUNGLE);
        this.g.add(BiomeBase.JUNGLE_HILLS);
    }

    public WorldChunkManager(long l, WorldType worldType) {
        this();
        GenLayer[] genLayerArray = GenLayer.a(l, worldType);
        this.d = genLayerArray[0];
        this.e = genLayerArray[1];
    }

    public WorldChunkManager(World world) {
        this(world.getSeed(), world.getWorldData().getType());
    }

    public List a() {
        return this.g;
    }

    public BiomeBase getBiome(int n, int n2) {
        return this.f.b(n, n2);
    }

    public float[] getWetness(float[] fArray, int n, int n2, int n3, int n4) {
        IntCache.a();
        if (fArray == null || fArray.length < n3 * n4) {
            fArray = new float[n3 * n4];
        }
        int[] nArray = this.e.a(n, n2, n3, n4);
        for (int i = 0; i < n3 * n4; ++i) {
            float f = (float)BiomeBase.biomes[nArray[i]].g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            fArray[i] = f;
        }
        return fArray;
    }

    public float[] getTemperatures(float[] fArray, int n, int n2, int n3, int n4) {
        IntCache.a();
        if (fArray == null || fArray.length < n3 * n4) {
            fArray = new float[n3 * n4];
        }
        int[] nArray = this.e.a(n, n2, n3, n4);
        for (int i = 0; i < n3 * n4; ++i) {
            float f = (float)BiomeBase.biomes[nArray[i]].h() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            fArray[i] = f;
        }
        return fArray;
    }

    public BiomeBase[] getBiomes(BiomeBase[] biomeBaseArray, int n, int n2, int n3, int n4) {
        IntCache.a();
        if (biomeBaseArray == null || biomeBaseArray.length < n3 * n4) {
            biomeBaseArray = new BiomeBase[n3 * n4];
        }
        int[] nArray = this.d.a(n, n2, n3, n4);
        for (int i = 0; i < n3 * n4; ++i) {
            biomeBaseArray[i] = BiomeBase.biomes[nArray[i]];
        }
        return biomeBaseArray;
    }

    public BiomeBase[] getBiomeBlock(BiomeBase[] biomeBaseArray, int n, int n2, int n3, int n4) {
        return this.a(biomeBaseArray, n, n2, n3, n4, true);
    }

    public BiomeBase[] a(BiomeBase[] biomeBaseArray, int n, int n2, int n3, int n4, boolean bl) {
        IntCache.a();
        if (biomeBaseArray == null || biomeBaseArray.length < n3 * n4) {
            biomeBaseArray = new BiomeBase[n3 * n4];
        }
        if (bl && n3 == 16 && n4 == 16 && (n & 0xF) == 0 && (n2 & 0xF) == 0) {
            BiomeBase[] biomeBaseArray2 = this.f.e(n, n2);
            System.arraycopy(biomeBaseArray2, 0, biomeBaseArray, 0, n3 * n4);
            return biomeBaseArray;
        }
        int[] nArray = this.e.a(n, n2, n3, n4);
        for (int i = 0; i < n3 * n4; ++i) {
            biomeBaseArray[i] = BiomeBase.biomes[nArray[i]];
        }
        return biomeBaseArray;
    }

    public boolean a(int n, int n2, int n3, List list) {
        int n4 = n - n3 >> 2;
        int n5 = n2 - n3 >> 2;
        int n6 = n + n3 >> 2;
        int n7 = n2 + n3 >> 2;
        int n8 = n6 - n4 + 1;
        int n9 = n7 - n5 + 1;
        int[] nArray = this.d.a(n4, n5, n8, n9);
        for (int i = 0; i < n8 * n9; ++i) {
            BiomeBase biomeBase = BiomeBase.biomes[nArray[i]];
            if (list.contains(biomeBase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition a(int n, int n2, int n3, List list, Random random) {
        int n4 = n - n3 >> 2;
        int n5 = n2 - n3 >> 2;
        int n6 = n + n3 >> 2;
        int n7 = n2 + n3 >> 2;
        int n8 = n6 - n4 + 1;
        int n9 = n7 - n5 + 1;
        int[] nArray = this.d.a(n4, n5, n8, n9);
        ChunkPosition chunkPosition = null;
        int n10 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n11 = n4 + i % n8 << 2;
            int n12 = n5 + i / n8 << 2;
            BiomeBase biomeBase = BiomeBase.biomes[nArray[i]];
            if (!list.contains(biomeBase) || chunkPosition != null && random.nextInt(n10 + 1) != 0) continue;
            chunkPosition = new ChunkPosition(n11, 0, n12);
            ++n10;
        }
        return chunkPosition;
    }

    public void b() {
        this.f.a();
    }
}

