/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import com.google.common.base.Preconditions;
import gnu.trove.map.TMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.md_5.bungee.util.CaseInsensitiveSet;

public class Configuration
implements ProxyConfig {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private TMap<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private boolean logCommands;
    private boolean logPings = true;
    private int playerLimit = -1;
    private Collection<String> disabledCommands;
    private int throttle = 4000;
    private int throttleLimit = 3;
    private boolean ipForward;
    private Favicon favicon;
    private int compressionThreshold = 256;
    private boolean preventProxyConnections;
    private boolean forgeSupport;
    private boolean injectCommands;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        File fav = new File("server-icon.png");
        if (fav.exists()) {
            try {
                this.favicon = Favicon.create(ImageIO.read(fav));
            }
            catch (IOException | IllegalArgumentException ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load server icon", ex);
            }
        }
        this.listeners = adapter.getListeners();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.logCommands = adapter.getBoolean("log_commands", this.logCommands);
        this.logPings = adapter.getBoolean("log_pings", this.logPings);
        this.playerLimit = adapter.getInt("player_limit", this.playerLimit);
        this.throttle = adapter.getInt("connection_throttle", this.throttle);
        this.throttleLimit = adapter.getInt("connection_throttle_limit", this.throttleLimit);
        this.ipForward = adapter.getBoolean("ip_forward", this.ipForward);
        this.compressionThreshold = adapter.getInt("network_compression_threshold", this.compressionThreshold);
        this.preventProxyConnections = adapter.getBoolean("prevent_proxy_connections", this.preventProxyConnections);
        this.forgeSupport = adapter.getBoolean("forge_support", this.forgeSupport);
        this.injectCommands = adapter.getBoolean("inject_commands", this.injectCommands);
        if (this.injectCommands) {
            System.setProperty("net.md-5.bungee.protocol.register_commands", "true");
        }
        this.disabledCommands = new CaseInsensitiveSet(adapter.getList("disabled_commands", Arrays.asList("disabledcommandhere")));
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        Map<String, ServerInfo> newServers = adapter.getServers();
        Preconditions.checkArgument(newServers != null && !newServers.isEmpty(), "No servers defined");
        if (this.servers == null) {
            this.servers = new CaseInsensitiveMap<ServerInfo>(newServers);
        } else {
            for (ServerInfo serverInfo : this.servers.values()) {
                Preconditions.checkArgument(newServers.containsKey(serverInfo.getName()), "Server %s removed on reload!", (Object)serverInfo.getName());
            }
            for (Map.Entry entry : newServers.entrySet()) {
                if (this.servers.containsValue(entry.getValue())) continue;
                this.servers.put((String)entry.getKey(), (ServerInfo)entry.getValue());
            }
        }
        for (ListenerInfo listenerInfo : this.listeners) {
            for (int i = 0; i < listenerInfo.getServerPriority().size(); ++i) {
                String server = listenerInfo.getServerPriority().get(i);
                Preconditions.checkArgument(this.servers.containsKey(server), "Server %s (priority %s) is not defined", (Object)server, i);
            }
            for (String server : listenerInfo.getForcedHosts().values()) {
                if (this.servers.containsKey(server)) continue;
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Forced host server {0} is not defined", server);
            }
        }
    }

    @Override
    @Deprecated
    public String getFavicon() {
        return this.getFaviconObject().getEncoded();
    }

    @Override
    public Favicon getFaviconObject() {
        return this.favicon;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public TMap<String, ServerInfo> getServers() {
        return this.servers;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public boolean isLogCommands() {
        return this.logCommands;
    }

    public boolean isLogPings() {
        return this.logPings;
    }

    @Override
    public int getPlayerLimit() {
        return this.playerLimit;
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Override
    public int getThrottle() {
        return this.throttle;
    }

    public int getThrottleLimit() {
        return this.throttleLimit;
    }

    @Override
    public boolean isIpForward() {
        return this.ipForward;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public boolean isPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public boolean isForgeSupport() {
        return this.forgeSupport;
    }

    public boolean isInjectCommands() {
        return this.injectCommands;
    }
}

