/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.CommandAbstract;
import net.minecraft.server.CommandDispatcher;
import net.minecraft.server.ConvertProgressUpdater;
import net.minecraft.server.Convertable;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportModded;
import net.minecraft.server.CrashReportPlayerCount;
import net.minecraft.server.CrashReportProfilerPosition;
import net.minecraft.server.DedicatedServer;
import net.minecraft.server.DemoWorldServer;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ExceptionWorldConflict;
import net.minecraft.server.ICommandHandler;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IMojangStatistics;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.LocaleLanguage;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MojangStatisticsGenerator;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.RemoteControlCommandListener;
import net.minecraft.server.ReportedException;
import net.minecraft.server.SecondaryWorldServer;
import net.minecraft.server.ServerConfigurationManagerAbstract;
import net.minecraft.server.ServerConnection;
import net.minecraft.server.StatisticList;
import net.minecraft.server.StripColor;
import net.minecraft.server.ThreadServerApplication;
import net.minecraft.server.ThreadShutdown;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldLoaderServer;
import net.minecraft.server.WorldManager;
import net.minecraft.server.WorldServer;
import net.minecraft.server.WorldSettings;
import net.minecraft.server.WorldType;

public abstract class MinecraftServer
implements Runnable,
IMojangStatistics,
ICommandListener {
    public static Logger log = Logger.getLogger("Minecraft");
    private static MinecraftServer l = null;
    private final Convertable convertable;
    private final MojangStatisticsGenerator n = new MojangStatisticsGenerator("server", this);
    private final File universe;
    private final List p = new ArrayList();
    private final ICommandHandler q;
    public final MethodProfiler methodProfiler = new MethodProfiler();
    private String serverIp;
    private int s = -1;
    public WorldServer[] worldServer;
    private ServerConfigurationManagerAbstract t;
    private boolean isRunning = true;
    private boolean isStopped = false;
    private int ticks = 0;
    public String d;
    public int e;
    private boolean onlineMode;
    private boolean spawnAnimals;
    private boolean spawnNPCs;
    private boolean pvpMode;
    private boolean allowFlight;
    private String motd;
    private int D;
    private long E;
    private long F;
    private long G;
    private long H;
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public final long[] j = new long[100];
    public long[][] k;
    private KeyPair I;
    private String J;
    private String K;
    private boolean demoMode;
    private boolean N;
    private boolean O;
    private String P = "";
    private boolean Q = false;
    private long R;
    private String S;
    private boolean T;

    public MinecraftServer(File file) {
        l = this;
        this.universe = file;
        this.q = new CommandDispatcher();
        this.convertable = new WorldLoaderServer(file);
    }

    protected abstract boolean init();

    protected void c(String string) {
        if (this.getConvertable().isConvertable(string)) {
            log.info("Converting map!");
            this.d("menu.convertingLevel");
            this.getConvertable().convert(string, new ConvertProgressUpdater(this));
        }
    }

    protected synchronized void d(String string) {
        this.S = string;
    }

    protected void a(String string, String string2, long l, WorldType worldType) {
        this.c(string);
        this.d("menu.loadingLevel");
        this.worldServer = new WorldServer[3];
        this.k = new long[this.worldServer.length][100];
        IDataManager iDataManager = this.convertable.a(string, true);
        WorldData worldData = iDataManager.getWorldData();
        WorldSettings worldSettings = worldData == null ? new WorldSettings(l, this.getGamemode(), this.getGenerateStructures(), this.isHardcore(), worldType) : new WorldSettings(worldData);
        if (this.N) {
            worldSettings.a();
        }
        for (int i = 0; i < this.worldServer.length; ++i) {
            int n = 0;
            if (i == 1) {
                n = -1;
            }
            if (i == 2) {
                n = 1;
            }
            this.worldServer[i] = i == 0 ? (this.L() ? new DemoWorldServer(this, iDataManager, string2, n, this.methodProfiler) : new WorldServer(this, iDataManager, string2, n, worldSettings, this.methodProfiler)) : new SecondaryWorldServer(this, iDataManager, string2, n, worldSettings, this.worldServer[0], this.methodProfiler);
            this.worldServer[i].addIWorldAccess(new WorldManager(this, this.worldServer[i]));
            if (!this.H()) {
                this.worldServer[i].getWorldData().setGameType(this.getGamemode());
            }
            this.t.setPlayerFileData(this.worldServer);
        }
        this.c(this.getDifficulty());
        this.d();
    }

    protected void d() {
        int n = 196;
        long l = System.currentTimeMillis();
        this.d("menu.generatingTerrain");
        for (int i = 0; i < 1; ++i) {
            log.info("Preparing start region for level " + i);
            WorldServer worldServer = this.worldServer[i];
            ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
            for (int j = -n; j <= n && this.isRunning(); j += 16) {
                for (int k = -n; k <= n && this.isRunning(); k += 16) {
                    long l2 = System.currentTimeMillis();
                    if (l2 < l) {
                        l = l2;
                    }
                    if (l2 > l + 1000L) {
                        int n2 = (n * 2 + 1) * (n * 2 + 1);
                        int n3 = (j + n) * (n * 2 + 1) + (k + 1);
                        this.a_("Preparing spawn area", n3 * 100 / n2);
                        l = l2;
                    }
                    worldServer.chunkProviderServer.getChunkAt(chunkCoordinates.x + j >> 4, chunkCoordinates.z + k >> 4);
                    while (worldServer.updateLights() && this.isRunning()) {
                    }
                }
            }
        }
        this.i();
    }

    public abstract boolean getGenerateStructures();

    public abstract EnumGamemode getGamemode();

    public abstract int getDifficulty();

    public abstract boolean isHardcore();

    protected void a_(String string, int n) {
        this.d = string;
        this.e = n;
        log.info(string + ": " + n + "%");
    }

    protected void i() {
        this.d = null;
        this.e = 0;
    }

    protected void saveChunks(boolean bl) {
        if (this.O) {
            return;
        }
        for (WorldServer worldServer : this.worldServer) {
            if (worldServer == null) continue;
            if (!bl) {
                log.info("Saving chunks for level '" + worldServer.getWorldData().getName() + "'/" + worldServer.worldProvider.getName());
            }
            try {
                worldServer.save(true, null);
            }
            catch (ExceptionWorldConflict exceptionWorldConflict) {
                log.warning(exceptionWorldConflict.getMessage());
            }
        }
    }

    public void stop() {
        if (this.O) {
            return;
        }
        log.info("Stopping server");
        if (this.ac() != null) {
            this.ac().a();
        }
        if (this.t != null) {
            log.info("Saving players");
            this.t.savePlayers();
            this.t.r();
        }
        log.info("Saving worlds");
        this.saveChunks(false);
        for (WorldServer worldServer : this.worldServer) {
            worldServer.saveLevel();
        }
        if (this.n != null && this.n.d()) {
            this.n.e();
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void e(String string) {
        this.serverIp = string;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void safeShutdown() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.init()) {
                long l = System.currentTimeMillis();
                long l2 = 0L;
                while (this.isRunning) {
                    long l3 = System.currentTimeMillis();
                    long l4 = l3 - l;
                    if (l4 > 2000L && l - this.R >= 15000L) {
                        log.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                        l4 = 2000L;
                        this.R = l;
                    }
                    if (l4 < 0L) {
                        log.warning("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    l = l3;
                    if (this.worldServer[0].everyoneDeeplySleeping()) {
                        this.p();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.p();
                        }
                    }
                    Thread.sleep(1L);
                    this.Q = true;
                }
            } else {
                this.a((CrashReport)null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.log(Level.SEVERE, "Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            CrashReport crashReport = null;
            crashReport = throwable instanceof ReportedException ? this.b(((ReportedException)throwable).a()) : this.b(new CrashReport("Exception in server tick loop", throwable));
            File file = new File(new File(this.n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.a(file)) {
                log.severe("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                log.severe("We were unable to save this crash report to disk.");
            }
            this.a(crashReport);
        }
        finally {
            try {
                this.stop();
                this.isStopped = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.o();
            }
        }
    }

    protected File n() {
        return new File(".");
    }

    protected void a(CrashReport crashReport) {
    }

    protected void o() {
    }

    protected void p() {
        long l = System.nanoTime();
        AxisAlignedBB.a().a();
        Vec3D.a().a();
        ++this.ticks;
        if (this.T) {
            this.T = false;
            this.methodProfiler.a = true;
            this.methodProfiler.a();
        }
        this.methodProfiler.a("root");
        this.q();
        if (this.ticks % 900 == 0) {
            this.methodProfiler.a("save");
            this.t.savePlayers();
            this.saveChunks(true);
            this.methodProfiler.b();
        }
        this.methodProfiler.a("tallying");
        this.j[this.ticks % 100] = System.nanoTime() - l;
        this.f[this.ticks % 100] = Packet.p - this.E;
        this.E = Packet.p;
        this.g[this.ticks % 100] = Packet.q - this.F;
        this.F = Packet.q;
        this.h[this.ticks % 100] = Packet.n - this.G;
        this.G = Packet.n;
        this.i[this.ticks % 100] = Packet.o - this.H;
        this.H = Packet.o;
        this.methodProfiler.b();
        this.methodProfiler.a("snooper");
        if (!this.n.d() && this.ticks > 100) {
            this.n.a();
        }
        if (this.ticks % 6000 == 0) {
            this.n.b();
        }
        this.methodProfiler.b();
        this.methodProfiler.b();
    }

    public void q() {
        this.methodProfiler.a("levels");
        for (int i = 0; i < this.worldServer.length; ++i) {
            long l = System.nanoTime();
            if (i == 0 || this.getAllowNether()) {
                WorldServer worldServer = this.worldServer[i];
                this.methodProfiler.a(worldServer.getWorldData().getName());
                if (this.ticks % 20 == 0) {
                    this.methodProfiler.a("timeSync");
                    this.t.a(new Packet4UpdateTime(worldServer.getTime()), worldServer.worldProvider.dimension);
                    this.methodProfiler.b();
                }
                this.methodProfiler.a("tick");
                worldServer.doTick();
                this.methodProfiler.c("lights");
                while (worldServer.updateLights()) {
                }
                this.methodProfiler.b();
                worldServer.tickEntities();
                this.methodProfiler.a("tracker");
                worldServer.getTracker().updatePlayers();
                this.methodProfiler.b();
                this.methodProfiler.b();
            }
            this.k[i][this.ticks % 100] = System.nanoTime() - l;
        }
        this.methodProfiler.c("connection");
        this.ac().b();
        this.methodProfiler.c("players");
        this.t.tick();
        this.methodProfiler.c("tickables");
        for (IUpdatePlayerListBox iUpdatePlayerListBox : this.p) {
            iUpdatePlayerListBox.a();
        }
        this.methodProfiler.b();
    }

    public boolean getAllowNether() {
        return true;
    }

    public void a(IUpdatePlayerListBox iUpdatePlayerListBox) {
        this.p.add(iUpdatePlayerListBox);
    }

    public static void main(String[] stringArray) {
        StatisticList.a();
        try {
            boolean bl = !GraphicsEnvironment.isHeadless();
            String string = null;
            String string2 = ".";
            String string3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                String string5 = i == stringArray.length - 1 ? null : stringArray[i + 1];
                boolean bl4 = false;
                if (string4.equals("nogui") || string4.equals("--nogui")) {
                    bl = false;
                } else if (string4.equals("--port") && string5 != null) {
                    bl4 = true;
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string4.equals("--singleplayer") && string5 != null) {
                    bl4 = true;
                    string = string5;
                } else if (string4.equals("--universe") && string5 != null) {
                    bl4 = true;
                    string2 = string5;
                } else if (string4.equals("--world") && string5 != null) {
                    bl4 = true;
                    string3 = string5;
                } else if (string4.equals("--demo")) {
                    bl2 = true;
                } else if (string4.equals("--bonusChest")) {
                    bl3 = true;
                }
                if (!bl4) continue;
                ++i;
            }
            DedicatedServer dedicatedServer = new DedicatedServer(new File(string2));
            if (string != null) {
                dedicatedServer.l(string);
            }
            if (string3 != null) {
                dedicatedServer.m(string3);
            }
            if (n >= 0) {
                dedicatedServer.setPort(n);
            }
            if (bl2) {
                dedicatedServer.b(true);
            }
            if (bl3) {
                dedicatedServer.c(true);
            }
            if (bl) {
                dedicatedServer.ak();
            }
            dedicatedServer.s();
            Runtime.getRuntime().addShutdownHook(new ThreadShutdown(dedicatedServer));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public void s() {
        new ThreadServerApplication(this, "Server thread").start();
    }

    public File f(String string) {
        return new File(this.n(), string);
    }

    public void info(String string) {
        log.info(string);
    }

    public void warning(String string) {
        log.warning(string);
    }

    public WorldServer getWorldServer(int n) {
        if (n == -1) {
            return this.worldServer[1];
        }
        if (n == 1) {
            return this.worldServer[2];
        }
        return this.worldServer[0];
    }

    public String t() {
        return this.serverIp;
    }

    public int u() {
        return this.s;
    }

    public String v() {
        return this.motd;
    }

    public String getVersion() {
        return "1.3.2";
    }

    public int x() {
        return this.t.getPlayerCount();
    }

    public int y() {
        return this.t.getMaxPlayers();
    }

    public String[] getPlayers() {
        return this.t.d();
    }

    public String getPlugins() {
        return "";
    }

    public String i(String string) {
        RemoteControlCommandListener.instance.b();
        this.q.a(RemoteControlCommandListener.instance, string);
        return RemoteControlCommandListener.instance.c();
    }

    public boolean isDebugging() {
        return false;
    }

    public void j(String string) {
        log.log(Level.SEVERE, string);
    }

    public void k(String string) {
        if (this.isDebugging()) {
            log.log(Level.INFO, string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport b(CrashReport crashReport) {
        crashReport.a("Is Modded", new CrashReportModded(this));
        crashReport.a("Profiler Position", new CrashReportProfilerPosition(this));
        if (this.t != null) {
            crashReport.a("Player Count", new CrashReportPlayerCount(this));
        }
        if (this.worldServer != null) {
            for (WorldServer worldServer : this.worldServer) {
                if (worldServer == null) continue;
                worldServer.a(crashReport);
            }
        }
        return crashReport;
    }

    public List a(ICommandListener iCommandListener, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("/")) {
            boolean bl = !(string = string.substring(1)).contains(" ");
            List list = this.q.b(iCommandListener, string);
            if (list != null) {
                for (String string2 : list) {
                    if (bl) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.t.d()) {
            if (!CommandAbstract.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer getServer() {
        return l;
    }

    public String getName() {
        return "Server";
    }

    public void sendMessage(String string) {
        log.info(StripColor.a(string));
    }

    public boolean b(String string) {
        return true;
    }

    public String a(String string, Object ... objectArray) {
        return LocaleLanguage.a().a(string, objectArray);
    }

    public ICommandHandler getCommandHandler() {
        return this.q;
    }

    public KeyPair E() {
        return this.I;
    }

    public int F() {
        return this.s;
    }

    public void setPort(int n) {
        this.s = n;
    }

    public String G() {
        return this.J;
    }

    public void l(String string) {
        this.J = string;
    }

    public boolean H() {
        return this.J != null;
    }

    public String I() {
        return this.K;
    }

    public void m(String string) {
        this.K = string;
    }

    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void c(int n) {
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            if (worldServer.getWorldData().isHardcore()) {
                worldServer.difficulty = 3;
                worldServer.setSpawnFlags(true, true);
                continue;
            }
            if (this.H()) {
                worldServer.difficulty = n;
                worldServer.setSpawnFlags(worldServer.difficulty > 0, true);
                continue;
            }
            worldServer.difficulty = n;
            worldServer.setSpawnFlags(this.getSpawnMonsters(), this.spawnAnimals);
        }
    }

    protected boolean getSpawnMonsters() {
        return true;
    }

    public boolean L() {
        return this.demoMode;
    }

    public void b(boolean bl) {
        this.demoMode = bl;
    }

    public void c(boolean bl) {
        this.N = bl;
    }

    public Convertable getConvertable() {
        return this.convertable;
    }

    public void O() {
        this.O = true;
        this.getConvertable().d();
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            worldServer.saveLevel();
        }
        this.getConvertable().e(this.worldServer[0].getDataManager().g());
        this.safeShutdown();
    }

    public String getTexturePack() {
        return this.P;
    }

    public void setTexturePack(String string) {
        this.P = string;
    }

    public void a(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("whitelist_enabled", false);
        mojangStatisticsGenerator.a("whitelist_count", 0);
        mojangStatisticsGenerator.a("players_current", this.x());
        mojangStatisticsGenerator.a("players_max", this.y());
        mojangStatisticsGenerator.a("players_seen", this.t.getSeenPlayers().length);
        mojangStatisticsGenerator.a("uses_auth", this.onlineMode);
        mojangStatisticsGenerator.a("gui_state", this.ae() ? "enabled" : "disabled");
        mojangStatisticsGenerator.a("avg_tick_ms", (int)(MathHelper.a(this.j) * 1.0E-6));
        mojangStatisticsGenerator.a("avg_sent_packet_count", (int)MathHelper.a(this.f));
        mojangStatisticsGenerator.a("avg_sent_packet_size", (int)MathHelper.a(this.g));
        mojangStatisticsGenerator.a("avg_rec_packet_count", (int)MathHelper.a(this.h));
        mojangStatisticsGenerator.a("avg_rec_packet_size", (int)MathHelper.a(this.i));
        int n = 0;
        for (int i = 0; i < this.worldServer.length; ++i) {
            if (this.worldServer[i] == null) continue;
            WorldServer worldServer = this.worldServer[i];
            WorldData worldData = worldServer.getWorldData();
            mojangStatisticsGenerator.a("world[" + n + "][dimension]", worldServer.worldProvider.dimension);
            mojangStatisticsGenerator.a("world[" + n + "][mode]", (Object)worldData.getGameType());
            mojangStatisticsGenerator.a("world[" + n + "][difficulty]", worldServer.difficulty);
            mojangStatisticsGenerator.a("world[" + n + "][hardcore]", worldData.isHardcore());
            mojangStatisticsGenerator.a("world[" + n + "][generator_name]", worldData.getType().name());
            mojangStatisticsGenerator.a("world[" + n + "][generator_version]", worldData.getType().getVersion());
            mojangStatisticsGenerator.a("world[" + n + "][height]", this.D);
            mojangStatisticsGenerator.a("world[" + n + "][chunks_loaded]", worldServer.F().getLoadedChunks());
            ++n;
        }
        mojangStatisticsGenerator.a("worlds", n);
    }

    public void b(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("singleplayer", this.H());
        mojangStatisticsGenerator.a("server_brand", this.getServerModName());
        mojangStatisticsGenerator.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        mojangStatisticsGenerator.a("dedicated", this.S());
    }

    public boolean getSnooperEnabled() {
        return true;
    }

    public int R() {
        return 16;
    }

    public abstract boolean S();

    public boolean getOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean bl) {
        this.onlineMode = bl;
    }

    public boolean getSpawnAnimals() {
        return this.spawnAnimals;
    }

    public void setSpawnAnimals(boolean bl) {
        this.spawnAnimals = bl;
    }

    public boolean getSpawnNPCs() {
        return this.spawnNPCs;
    }

    public void setSpawnNPCs(boolean bl) {
        this.spawnNPCs = bl;
    }

    public boolean getPvP() {
        return this.pvpMode;
    }

    public void setPvP(boolean bl) {
        this.pvpMode = bl;
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean bl) {
        this.allowFlight = bl;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String string) {
        this.motd = string;
    }

    public int getMaxBuildHeight() {
        return this.D;
    }

    public void d(int n) {
        this.D = n;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public ServerConfigurationManagerAbstract getServerConfigurationManager() {
        return this.t;
    }

    public void a(ServerConfigurationManagerAbstract serverConfigurationManagerAbstract) {
        this.t = serverConfigurationManagerAbstract;
    }

    public void a(EnumGamemode enumGamemode) {
        for (int i = 0; i < this.worldServer.length; ++i) {
            MinecraftServer.getServer().worldServer[i].getWorldData().setGameType(enumGamemode);
        }
    }

    public abstract ServerConnection ac();

    public boolean ae() {
        return false;
    }

    public abstract String a(EnumGamemode var1, boolean var2);

    public int af() {
        return this.ticks;
    }

    public void ag() {
        this.T = true;
    }

    public static /* synthetic */ ServerConfigurationManagerAbstract a(MinecraftServer minecraftServer) {
        return minecraftServer.t;
    }
}

