/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.server.ConsoleLogManager;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportType;
import net.minecraft.server.DedicatedServerConnection;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftEncryption;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MojangStatisticsGenerator;
import net.minecraft.server.PropertyManager;
import net.minecraft.server.RemoteControlListener;
import net.minecraft.server.RemoteStatusListener;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerConfigurationManager;
import net.minecraft.server.ServerConfigurationManagerAbstract;
import net.minecraft.server.ServerConnection;
import net.minecraft.server.ServerGUI;
import net.minecraft.server.ThreadCommandReader;
import net.minecraft.server.ThreadSleepForever;
import net.minecraft.server.WorldSettings;
import net.minecraft.server.WorldType;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    private final List l = Collections.synchronizedList(new ArrayList());
    private RemoteStatusListener m;
    private RemoteControlListener n;
    private PropertyManager propertyManager;
    private boolean generateStructures;
    private EnumGamemode q;
    private ServerConnection r;
    private boolean s = false;

    public DedicatedServer(File file) {
        super(file);
        new ThreadSleepForever(this);
    }

    protected boolean init() {
        WorldType worldType;
        ThreadCommandReader threadCommandReader = new ThreadCommandReader(this);
        threadCommandReader.setDaemon(true);
        threadCommandReader.start();
        ConsoleLogManager.init();
        log.info("Starting minecraft server version 1.3.2");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            log.warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        log.info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"));
        if (this.H()) {
            this.e("127.0.0.1");
        } else {
            this.setOnlineMode(this.propertyManager.getBoolean("online-mode", true));
            this.e(this.propertyManager.getString("server-ip", ""));
        }
        this.setSpawnAnimals(this.propertyManager.getBoolean("spawn-animals", true));
        this.setSpawnNPCs(this.propertyManager.getBoolean("spawn-npcs", true));
        this.setPvP(this.propertyManager.getBoolean("pvp", true));
        this.setAllowFlight(this.propertyManager.getBoolean("allow-flight", false));
        this.setTexturePack(this.propertyManager.getString("texture-pack", ""));
        this.setMotd(this.propertyManager.getString("motd", "A Minecraft Server"));
        this.generateStructures = this.propertyManager.getBoolean("generate-structures", true);
        int n = this.propertyManager.getInt("gamemode", EnumGamemode.SURVIVAL.a());
        this.q = WorldSettings.a(n);
        log.info("Default game type: " + (Object)((Object)this.q));
        InetAddress inetAddress = null;
        if (this.getServerIp().length() > 0) {
            inetAddress = InetAddress.getByName(this.getServerIp());
        }
        if (this.F() < 0) {
            this.setPort(this.propertyManager.getInt("server-port", 25565));
        }
        log.info("Generating keypair");
        this.a(MinecraftEncryption.b());
        log.info("Starting Minecraft server on " + (this.getServerIp().length() == 0 ? "*" : this.getServerIp()) + ":" + this.F());
        try {
            this.r = new DedicatedServerConnection(this, inetAddress, this.F());
        }
        catch (IOException iOException) {
            log.warning("**** FAILED TO BIND TO PORT!");
            log.log(Level.WARNING, "The exception was: " + iOException.toString());
            log.warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.getOnlineMode()) {
            log.warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            log.warning("The server will make no attempt to authenticate usernames. Beware.");
            log.warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            log.warning("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        this.a(new ServerConfigurationManager(this));
        long l = System.nanoTime();
        if (this.I() == null) {
            this.m(this.propertyManager.getString("level-name", "world"));
        }
        String string = this.propertyManager.getString("level-seed", "");
        String string2 = this.propertyManager.getString("level-type", "DEFAULT");
        long l2 = new Random().nextLong();
        if (string.length() > 0) {
            try {
                long l3 = Long.parseLong(string);
                if (l3 != 0L) {
                    l2 = l3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l2 = string.hashCode();
            }
        }
        if ((worldType = WorldType.getType(string2)) == null) {
            worldType = WorldType.NORMAL;
        }
        this.d(this.propertyManager.getInt("max-build-height", 256));
        this.d((this.getMaxBuildHeight() + 8) / 16 * 16);
        this.d(MathHelper.a(this.getMaxBuildHeight(), 64, 256));
        this.propertyManager.a("max-build-height", this.getMaxBuildHeight());
        log.info("Preparing level \"" + this.I() + "\"");
        this.a(this.I(), this.I(), l2, worldType);
        long l4 = System.nanoTime() - l;
        String string3 = String.format("%.3fs", (double)l4 / 1.0E9);
        log.info("Done (" + string3 + ")! For help, type \"help\" or \"?\"");
        if (this.propertyManager.getBoolean("enable-query", false)) {
            log.info("Starting GS4 status listener");
            this.m = new RemoteStatusListener(this);
            this.m.a();
        }
        if (this.propertyManager.getBoolean("enable-rcon", false)) {
            log.info("Starting remote control listener");
            this.n = new RemoteControlListener(this);
            this.n.a();
        }
        return true;
    }

    public boolean getGenerateStructures() {
        return this.generateStructures;
    }

    public EnumGamemode getGamemode() {
        return this.q;
    }

    public int getDifficulty() {
        return this.propertyManager.getInt("difficulty", 1);
    }

    public boolean isHardcore() {
        return this.propertyManager.getBoolean("hardcore", false);
    }

    protected void a(CrashReport crashReport) {
        while (this.isRunning()) {
            this.ai();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    protected CrashReport b(CrashReport crashReport) {
        crashReport = super.b(crashReport);
        crashReport.a("Type", new CrashReportType(this));
        return crashReport;
    }

    protected void o() {
        System.exit(0);
    }

    protected void q() {
        super.q();
        this.ai();
    }

    public boolean getAllowNether() {
        return this.propertyManager.getBoolean("allow-nether", true);
    }

    public boolean getSpawnMonsters() {
        return this.propertyManager.getBoolean("spawn-monsters", true);
    }

    public void a(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("whitelist_enabled", this.aj().getHasWhitelist());
        mojangStatisticsGenerator.a("whitelist_count", this.aj().getWhitelisted().size());
        super.a(mojangStatisticsGenerator);
    }

    public boolean getSnooperEnabled() {
        return this.propertyManager.getBoolean("snooper-enabled", true);
    }

    public void issueCommand(String string, ICommandListener iCommandListener) {
        this.l.add(new ServerCommand(string, iCommandListener));
    }

    public void ai() {
        while (!this.l.isEmpty()) {
            ServerCommand serverCommand = (ServerCommand)this.l.remove(0);
            this.getCommandHandler().a(serverCommand.source, serverCommand.command);
        }
    }

    public boolean S() {
        return true;
    }

    public ServerConfigurationManager aj() {
        return (ServerConfigurationManager)super.getServerConfigurationManager();
    }

    public ServerConnection ac() {
        return this.r;
    }

    public int a(String string, int n) {
        return this.propertyManager.getInt(string, n);
    }

    public String a(String string, String string2) {
        return this.propertyManager.getString(string, string2);
    }

    public boolean a(String string, boolean bl) {
        return this.propertyManager.getBoolean(string, bl);
    }

    public void a(String string, Object object) {
        this.propertyManager.a(string, object);
    }

    public void a() {
        this.propertyManager.savePropertiesFile();
    }

    public String c() {
        File file = this.propertyManager.c();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "No settings file";
    }

    public void ak() {
        ServerGUI.a(this);
        this.s = true;
    }

    public boolean ae() {
        return this.s;
    }

    public String a(EnumGamemode enumGamemode, boolean bl) {
        return "";
    }

    public /* synthetic */ ServerConfigurationManagerAbstract getServerConfigurationManager() {
        return this.aj();
    }
}

