/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenVillage;

public class ChunkProviderFlat
implements IChunkProvider {
    private World a;
    private Random b;
    private final boolean c;
    private WorldGenVillage d = new WorldGenVillage(1);

    public ChunkProviderFlat(World world, long l, boolean bl) {
        this.a = world;
        this.c = bl;
        this.b = new Random(l);
    }

    private void a(byte[] byArray) {
        int n = byArray.length / 256;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n2 = 0;
                    if (k == 0) {
                        n2 = Block.BEDROCK.id;
                    } else if (k <= 2) {
                        n2 = Block.DIRT.id;
                    } else if (k == 3) {
                        n2 = Block.GRASS.id;
                    }
                    byArray[i << 11 | j << 7 | k] = (byte)n2;
                }
            }
        }
    }

    public Chunk getChunkAt(int n, int n2) {
        return this.getOrCreateChunk(n, n2);
    }

    public Chunk getOrCreateChunk(int n, int n2) {
        byte[] byArray = new byte[32768];
        this.a(byArray);
        Chunk chunk = new Chunk(this.a, byArray, n, n2);
        if (this.c) {
            this.d.a(this, this.a, n, n2, byArray);
        }
        BiomeBase[] biomeBaseArray = this.a.getWorldChunkManager().getBiomeBlock(null, n * 16, n2 * 16, 16, 16);
        byte[] byArray2 = chunk.m();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)biomeBaseArray[i].id;
        }
        chunk.initLighting();
        return chunk;
    }

    public boolean isChunkLoaded(int n, int n2) {
        return true;
    }

    public void getChunkAt(IChunkProvider iChunkProvider, int n, int n2) {
        this.b.setSeed(this.a.getSeed());
        long l = this.b.nextLong() / 2L * 2L + 1L;
        long l2 = this.b.nextLong() / 2L * 2L + 1L;
        this.b.setSeed((long)n * l + (long)n2 * l2 ^ this.a.getSeed());
        if (this.c) {
            this.d.a(this.a, this.b, n, n2);
        }
    }

    public boolean saveChunks(boolean bl, IProgressUpdate iProgressUpdate) {
        return true;
    }

    public boolean unloadChunks() {
        return false;
    }

    public boolean canSave() {
        return true;
    }

    public String getName() {
        return "FlatLevelSource";
    }

    public List getMobsFor(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        BiomeBase biomeBase = this.a.getBiome(n, n3);
        if (biomeBase == null) {
            return null;
        }
        return biomeBase.getMobs(enumCreatureType);
    }

    public ChunkPosition findNearestMapFeature(World world, String string, int n, int n2, int n3) {
        return null;
    }

    public int getLoadedChunks() {
        return 0;
    }
}

