/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.NBTBase;

public class NBTTagString
extends NBTBase {
    public String data;

    public NBTTagString(String string) {
        super(string);
    }

    public NBTTagString(String string, String string2) {
        super(string);
        this.data = string2;
        if (string2 == null) {
            throw new IllegalArgumentException("Empty string not allowed");
        }
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeUTF(this.data);
    }

    void load(DataInput dataInput) {
        this.data = dataInput.readUTF();
    }

    public byte getTypeId() {
        return 8;
    }

    public String toString() {
        return "" + this.data;
    }

    public NBTBase clone() {
        return new NBTTagString(this.getName(), this.data);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagString nBTTagString = (NBTTagString)object;
            return this.data == null && nBTTagString.data == null || this.data != null && this.data.equals(nBTTagString.data);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.data.hashCode();
    }
}

