/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.NBTBase;

public class NBTTagFloat
extends NBTBase {
    public float data;

    public NBTTagFloat(String string) {
        super(string);
    }

    public NBTTagFloat(String string, float f) {
        super(string);
        this.data = f;
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeFloat(this.data);
    }

    void load(DataInput dataInput) {
        this.data = dataInput.readFloat();
    }

    public byte getTypeId() {
        return 5;
    }

    public String toString() {
        return "" + this.data;
    }

    public NBTBase clone() {
        return new NBTTagFloat(this.getName(), this.data);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagFloat nBTTagFloat = (NBTTagFloat)object;
            return this.data == nBTTagFloat.data;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }
}

