/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public final class ItemStack {
    public int count = 0;
    public int b;
    public int id;
    public NBTTagCompound tag;
    private int damage;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int n) {
        this(block.id, n, 0);
    }

    public ItemStack(Block block, int n, int n2) {
        this(block.id, n, n2);
    }

    public ItemStack(Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(Item item, int n) {
        this(item.id, n, 0);
    }

    public ItemStack(Item item, int n, int n2) {
        this(item.id, n, n2);
    }

    public ItemStack(int n, int n2, int n3) {
        this.id = n;
        this.count = n2;
        this.damage = n3;
    }

    public static ItemStack a(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = new ItemStack();
        itemStack.c(nBTTagCompound);
        return itemStack.getItem() != null ? itemStack : null;
    }

    private ItemStack() {
    }

    public ItemStack a(int n) {
        ItemStack itemStack = new ItemStack(this.id, n, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.clone();
        }
        this.count -= n;
        return itemStack;
    }

    public Item getItem() {
        return Item.byId[this.id];
    }

    public boolean placeItem(EntityHuman entityHuman, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        boolean bl = this.getItem().interactWith(this, entityHuman, world, n, n2, n3, n4, f, f2, f3);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
        return bl;
    }

    public float a(Block block) {
        return this.getItem().getDestroySpeed(this, block);
    }

    public ItemStack a(World world, EntityHuman entityHuman) {
        return this.getItem().a(this, world, entityHuman);
    }

    public ItemStack b(World world, EntityHuman entityHuman) {
        return this.getItem().b(this, world, entityHuman);
    }

    public NBTTagCompound save(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("id", (short)this.id);
        nBTTagCompound.setByte("Count", (byte)this.count);
        nBTTagCompound.setShort("Damage", (short)this.damage);
        if (this.tag != null) {
            nBTTagCompound.set("tag", this.tag);
        }
        return nBTTagCompound;
    }

    public void c(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.getShort("id");
        this.count = nBTTagCompound.getByte("Count");
        this.damage = nBTTagCompound.getShort("Damage");
        if (nBTTagCompound.hasKey("tag")) {
            this.tag = nBTTagCompound.getCompound("tag");
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.f() || !this.h());
    }

    public boolean f() {
        return Item.byId[this.id].getMaxDurability() > 0;
    }

    public boolean usesData() {
        return Item.byId[this.id].k();
    }

    public boolean h() {
        return this.f() && this.damage > 0;
    }

    public int i() {
        return this.damage;
    }

    public int getData() {
        return this.damage;
    }

    public void setData(int n) {
        this.damage = n;
    }

    public int k() {
        return Item.byId[this.id].getMaxDurability();
    }

    public void damage(int n, EntityLiving entityLiving) {
        int n2;
        if (!this.f()) {
            return;
        }
        if (n > 0 && entityLiving instanceof EntityHuman && (n2 = EnchantmentManager.getDurabilityEnchantmentLevel(((EntityHuman)entityLiving).inventory)) > 0 && entityLiving.world.random.nextInt(n2 + 1) > 0) {
            return;
        }
        if (!(entityLiving instanceof EntityHuman) || !((EntityHuman)entityLiving).abilities.canInstantlyBuild) {
            this.damage += n;
        }
        if (this.damage > this.k()) {
            entityLiving.a(this);
            if (entityLiving instanceof EntityHuman) {
                ((EntityHuman)entityLiving).a(StatisticList.F[this.id], 1);
            }
            --this.count;
            if (this.count < 0) {
                this.count = 0;
            }
            this.damage = 0;
        }
    }

    public void a(EntityLiving entityLiving, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, entityLiving, (EntityLiving)entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public void a(World world, int n, int n2, int n3, int n4, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, world, n, n2, n3, n4, entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public int a(Entity entity) {
        return Item.byId[this.id].a(entity);
    }

    public boolean b(Block block) {
        return Item.byId[this.id].canDestroySpecialBlock(block);
    }

    public boolean a(EntityLiving entityLiving) {
        return Item.byId[this.id].a(this, entityLiving);
    }

    public ItemStack cloneItemStack() {
        ItemStack itemStack = new ItemStack(this.id, this.count, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.clone();
        }
        return itemStack;
    }

    public static boolean equals(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null && itemStack2 == null) {
            return true;
        }
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (itemStack.tag == null && itemStack2.tag != null) {
            return false;
        }
        return itemStack.tag == null || itemStack.tag.equals(itemStack2.tag);
    }

    public static boolean matches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null && itemStack2 == null) {
            return true;
        }
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        return itemStack.d(itemStack2);
    }

    private boolean d(ItemStack itemStack) {
        if (this.count != itemStack.count) {
            return false;
        }
        if (this.id != itemStack.id) {
            return false;
        }
        if (this.damage != itemStack.damage) {
            return false;
        }
        if (this.tag == null && itemStack.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals(itemStack.tag);
    }

    public boolean doMaterialsMatch(ItemStack itemStack) {
        return this.id == itemStack.id && this.damage == itemStack.damage;
    }

    public String a() {
        return Item.byId[this.id].c(this);
    }

    public static ItemStack b(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.cloneItemStack();
    }

    public String toString() {
        return this.count + "x" + Item.byId[this.id].getName() + "@" + this.damage;
    }

    public void a(World world, Entity entity, int n, boolean bl) {
        if (this.b > 0) {
            --this.b;
        }
        Item.byId[this.id].a(this, world, entity, n, bl);
    }

    public void a(World world, EntityHuman entityHuman, int n) {
        entityHuman.a(StatisticList.D[this.id], n);
        Item.byId[this.id].d(this, world, entityHuman);
    }

    public boolean c(ItemStack itemStack) {
        return this.id == itemStack.id && this.count == itemStack.count && this.damage == itemStack.damage;
    }

    public int m() {
        return this.getItem().a(this);
    }

    public EnumAnimation n() {
        return this.getItem().b(this);
    }

    public void b(World world, EntityHuman entityHuman, int n) {
        this.getItem().a(this, world, entityHuman, n);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public NBTTagList getEnchantments() {
        if (this.tag == null) {
            return null;
        }
        return (NBTTagList)this.tag.get("ench");
    }

    public void setTag(NBTTagCompound nBTTagCompound) {
        this.tag = nBTTagCompound;
    }

    public boolean u() {
        if (!this.getItem().k(this)) {
            return false;
        }
        return !this.hasEnchantments();
    }

    public void addEnchantment(Enchantment enchantment, int n) {
        if (this.tag == null) {
            this.setTag(new NBTTagCompound());
        }
        if (!this.tag.hasKey("ench")) {
            this.tag.set("ench", new NBTTagList("ench"));
        }
        NBTTagList nBTTagList = (NBTTagList)this.tag.get("ench");
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.setShort("id", (short)enchantment.id);
        nBTTagCompound.setShort("lvl", (byte)n);
        nBTTagList.add(nBTTagCompound);
    }

    public boolean hasEnchantments() {
        return this.tag != null && this.tag.hasKey("ench");
    }
}

