/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Facing;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityPiston;
import net.minecraft.server.World;

public class BlockPistonMoving
extends BlockContainer {
    public BlockPistonMoving(int n) {
        super(n, Material.PISTON);
        this.c(-1.0f);
    }

    public TileEntity a(World world) {
        return null;
    }

    public void onPlace(World world, int n, int n2, int n3) {
    }

    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity = world.getTileEntity(n, n2, n3);
        if (tileEntity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileEntity).i();
        } else {
            super.remove(world, n, n2, n3, n4, n5);
        }
    }

    public boolean canPlace(World world, int n, int n2, int n3) {
        return false;
    }

    public boolean canPlace(World world, int n, int n2, int n3, int n4) {
        return false;
    }

    public int b() {
        return -1;
    }

    public boolean d() {
        return false;
    }

    public boolean c() {
        return false;
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (!world.isStatic && world.getTileEntity(n, n2, n3) == null) {
            world.setTypeId(n, n2, n3, 0);
            return true;
        }
        return false;
    }

    public int getDropType(int n, Random random, int n2) {
        return 0;
    }

    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
        if (world.isStatic) {
            return;
        }
        TileEntityPiston tileEntityPiston = this.d((IBlockAccess)world, n, n2, n3);
        if (tileEntityPiston == null) {
            return;
        }
        Block.byId[tileEntityPiston.a()].c(world, n, n2, n3, tileEntityPiston.n(), 0);
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (world.isStatic || world.getTileEntity(n, n2, n3) == null) {
            // empty if block
        }
    }

    public static TileEntity a(int n, int n2, int n3, boolean bl, boolean bl2) {
        return new TileEntityPiston(n, n2, n3, bl, bl2);
    }

    public AxisAlignedBB e(World world, int n, int n2, int n3) {
        TileEntityPiston tileEntityPiston = this.d((IBlockAccess)world, n, n2, n3);
        if (tileEntityPiston == null) {
            return null;
        }
        float f = tileEntityPiston.a(0.0f);
        if (tileEntityPiston.b()) {
            f = 1.0f - f;
        }
        return this.b(world, n, n2, n3, tileEntityPiston.a(), f, tileEntityPiston.c());
    }

    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntityPiston tileEntityPiston = this.d(iBlockAccess, n, n2, n3);
        if (tileEntityPiston != null) {
            Block block = Block.byId[tileEntityPiston.a()];
            if (block == null || block == this) {
                return;
            }
            block.updateShape(iBlockAccess, n, n2, n3);
            float f = tileEntityPiston.a(0.0f);
            if (tileEntityPiston.b()) {
                f = 1.0f - f;
            }
            int n4 = tileEntityPiston.c();
            this.minX = block.minX - (double)((float)Facing.b[n4] * f);
            this.minY = block.minY - (double)((float)Facing.c[n4] * f);
            this.minZ = block.minZ - (double)((float)Facing.d[n4] * f);
            this.maxX = block.maxX - (double)((float)Facing.b[n4] * f);
            this.maxY = block.maxY - (double)((float)Facing.c[n4] * f);
            this.maxZ = block.maxZ - (double)((float)Facing.d[n4] * f);
        }
    }

    public AxisAlignedBB b(World world, int n, int n2, int n3, int n4, float f, int n5) {
        if (n4 == 0 || n4 == this.id) {
            return null;
        }
        AxisAlignedBB axisAlignedBB = Block.byId[n4].e(world, n, n2, n3);
        if (axisAlignedBB == null) {
            return null;
        }
        if (Facing.b[n5] < 0) {
            axisAlignedBB.a -= (double)((float)Facing.b[n5] * f);
        } else {
            axisAlignedBB.d -= (double)((float)Facing.b[n5] * f);
        }
        if (Facing.c[n5] < 0) {
            axisAlignedBB.b -= (double)((float)Facing.c[n5] * f);
        } else {
            axisAlignedBB.e -= (double)((float)Facing.c[n5] * f);
        }
        if (Facing.d[n5] < 0) {
            axisAlignedBB.c -= (double)((float)Facing.d[n5] * f);
        } else {
            axisAlignedBB.f -= (double)((float)Facing.d[n5] * f);
        }
        return axisAlignedBB;
    }

    private TileEntityPiston d(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntity tileEntity = iBlockAccess.getTileEntity(n, n2, n3);
        if (tileEntity instanceof TileEntityPiston) {
            return (TileEntityPiston)tileEntity;
        }
        return null;
    }
}

