/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class ComponentBuilder {
    private BaseComponent current;
    private final List<BaseComponent> parts = new ArrayList<BaseComponent>();

    public ComponentBuilder(ComponentBuilder original) {
        this.current = new TextComponent(new BaseComponent[]{original.current});
        for (BaseComponent baseComponent : original.parts) {
            this.parts.add(baseComponent.duplicate());
        }
    }

    public ComponentBuilder(String text) {
        this.current = new TextComponent(text);
    }

    public ComponentBuilder append(BaseComponent[] components) {
        return this.append(components, FormatRetention.ALL);
    }

    public ComponentBuilder append(BaseComponent[] components, FormatRetention retention) {
        Preconditions.checkArgument(components.length != 0, "No components to append");
        for (BaseComponent component : components) {
            this.parts.add(this.current);
            this.current = component.duplicate();
            this.retain(retention);
        }
        return this;
    }

    public ComponentBuilder append(String text) {
        return this.append(text, FormatRetention.ALL);
    }

    public ComponentBuilder append(String text, FormatRetention retention) {
        this.parts.add(this.current);
        this.current = new TextComponent((TextComponent)this.current);
        ((TextComponent)this.current).setText(text);
        this.retain(retention);
        return this;
    }

    public ComponentBuilder color(ChatColor color) {
        this.current.setColor(color);
        return this;
    }

    public ComponentBuilder bold(boolean bold) {
        this.current.setBold(bold);
        return this;
    }

    public ComponentBuilder italic(boolean italic) {
        this.current.setItalic(italic);
        return this;
    }

    public ComponentBuilder underlined(boolean underlined) {
        this.current.setUnderlined(underlined);
        return this;
    }

    public ComponentBuilder strikethrough(boolean strikethrough) {
        this.current.setStrikethrough(strikethrough);
        return this;
    }

    public ComponentBuilder obfuscated(boolean obfuscated) {
        this.current.setObfuscated(obfuscated);
        return this;
    }

    public ComponentBuilder insertion(String insertion) {
        this.current.setInsertion(insertion);
        return this;
    }

    public ComponentBuilder event(ClickEvent clickEvent) {
        this.current.setClickEvent(clickEvent);
        return this;
    }

    public ComponentBuilder event(HoverEvent hoverEvent) {
        this.current.setHoverEvent(hoverEvent);
        return this;
    }

    public ComponentBuilder reset() {
        return this.retain(FormatRetention.NONE);
    }

    public ComponentBuilder retain(FormatRetention retention) {
        BaseComponent previous = this.current;
        switch (retention) {
            case NONE: {
                if (this.current instanceof TextComponent) {
                    this.current = new TextComponent(((TextComponent)this.current).getText());
                    break;
                }
                if (!(this.current instanceof TranslatableComponent)) break;
                TranslatableComponent oldComponent = (TranslatableComponent)this.current;
                this.current = new TranslatableComponent(oldComponent.getTranslate(), oldComponent.getWith());
                break;
            }
            case ALL: {
                break;
            }
            case EVENTS: {
                if (this.current instanceof TextComponent) {
                    this.current = new TextComponent(((TextComponent)this.current).getText());
                } else if (this.current instanceof TranslatableComponent) {
                    TranslatableComponent oldComponent = (TranslatableComponent)this.current;
                    this.current = new TranslatableComponent(oldComponent.getTranslate(), oldComponent.getWith());
                }
                this.current.setInsertion(previous.getInsertion());
                this.current.setClickEvent(previous.getClickEvent());
                this.current.setHoverEvent(previous.getHoverEvent());
                break;
            }
            case FORMATTING: {
                this.current.setClickEvent(null);
                this.current.setHoverEvent(null);
            }
        }
        return this;
    }

    public BaseComponent[] create() {
        BaseComponent[] result = this.parts.toArray(new BaseComponent[this.parts.size() + 1]);
        result[this.parts.size()] = this.current;
        return result;
    }

    public static enum FormatRetention {
        NONE,
        FORMATTING,
        EVENTS,
        ALL;

    }
}

