/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EncryptionRequest
extends DefinedPacket {
    private String serverId;
    private byte[] publicKey;
    private byte[] verifyToken;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.serverId = EncryptionRequest.readString(buf);
        this.publicKey = EncryptionRequest.readArray(buf);
        this.verifyToken = EncryptionRequest.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        EncryptionRequest.writeString(this.serverId, buf);
        EncryptionRequest.writeArray(this.publicKey, buf);
        EncryptionRequest.writeArray(this.verifyToken, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getServerId() {
        return this.serverId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    @Override
    public String toString() {
        return "EncryptionRequest(serverId=" + this.getServerId() + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    public EncryptionRequest() {
    }

    @ConstructorProperties(value={"serverId", "publicKey", "verifyToken"})
    public EncryptionRequest(String serverId, byte[] publicKey, byte[] verifyToken) {
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.verifyToken = verifyToken;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionRequest)) {
            return false;
        }
        EncryptionRequest other = (EncryptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptionRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 0 : $serverId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        result = result * 59 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }
}

