/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration
extends ConfigurationProvider {
    private final ThreadLocal<Yaml> yaml = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return new Yaml(options);
        }
    };

    @Override
    public void save(Configuration config, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.save(config, writer);
        }
    }

    @Override
    public void save(Configuration config, Writer writer) {
        this.yaml.get().dump(config.self, writer);
    }

    @Override
    public Configuration load(File file) throws IOException {
        return this.load(file, null);
    }

    @Override
    public Configuration load(File file, Configuration defaults) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Configuration configuration = this.load(reader, defaults);
            return configuration;
        }
    }

    @Override
    public Configuration load(Reader reader) {
        return this.load(reader, null);
    }

    @Override
    public Configuration load(Reader reader, Configuration defaults) {
        LinkedHashMap<String, Object> map = this.yaml.get().loadAs(reader, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        return new Configuration(map, defaults);
    }

    @Override
    public Configuration load(InputStream is) {
        return this.load(is, null);
    }

    @Override
    public Configuration load(InputStream is, Configuration defaults) {
        LinkedHashMap<String, Object> map = this.yaml.get().loadAs(is, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        return new Configuration(map, defaults);
    }

    @Override
    public Configuration load(String string) {
        return this.load(string, null);
    }

    @Override
    public Configuration load(String string, Configuration defaults) {
        LinkedHashMap<String, Object> map = this.yaml.get().loadAs(string, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        return new Configuration(map, defaults);
    }

    YamlConfiguration() {
    }
}

