/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityEnderCrystal;
import net.minecraft.server.EntityEnderDragon;
import net.minecraft.server.EntityEnderPearl;
import net.minecraft.server.EntityEnderSignal;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityFallingBlock;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityPainting;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.EntityThrownExpBottle;
import net.minecraft.server.IAnimal;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet20NamedEntitySpawn;
import net.minecraft.server.Packet21PickupSpawn;
import net.minecraft.server.Packet23VehicleSpawn;
import net.minecraft.server.Packet24MobSpawn;
import net.minecraft.server.Packet25EntityPainting;
import net.minecraft.server.Packet26AddExpOrb;
import net.minecraft.server.Packet28EntityVelocity;
import net.minecraft.server.Packet31RelEntityMove;
import net.minecraft.server.Packet32EntityLook;
import net.minecraft.server.Packet33RelEntityMoveLook;
import net.minecraft.server.Packet34EntityTeleport;
import net.minecraft.server.Packet35EntityHeadRotation;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.Packet40EntityMetadata;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet5EntityEquipment;

public class EntityTrackerEntry {
    public Entity tracker;
    public int b;
    public int c;
    public int xLoc;
    public int yLoc;
    public int zLoc;
    public int yRot;
    public int xRot;
    public int i;
    public double j;
    public double k;
    public double l;
    public int m = 0;
    private double p;
    private double q;
    private double r;
    private boolean s = false;
    private boolean isMoving;
    private int u = 0;
    private Entity v;
    public boolean n = false;
    public Set trackedPlayers = new HashSet();

    public EntityTrackerEntry(Entity entity, int n, int n2, boolean bl) {
        this.tracker = entity;
        this.b = n;
        this.c = n2;
        this.isMoving = bl;
        this.xLoc = MathHelper.floor(entity.locX * 32.0);
        this.yLoc = MathHelper.floor(entity.locY * 32.0);
        this.zLoc = MathHelper.floor(entity.locZ * 32.0);
        this.yRot = MathHelper.d(entity.yaw * 256.0f / 360.0f);
        this.xRot = MathHelper.d(entity.pitch * 256.0f / 360.0f);
        this.i = MathHelper.d(entity.am() * 256.0f / 360.0f);
    }

    public boolean equals(Object object) {
        if (object instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)object).tracker.id == this.tracker.id;
        }
        return false;
    }

    public int hashCode() {
        return this.tracker.id;
    }

    public void track(List list) {
        this.n = false;
        if (!this.s || this.tracker.e(this.p, this.q, this.r) > 16.0) {
            this.p = this.tracker.locX;
            this.q = this.tracker.locY;
            this.r = this.tracker.locZ;
            this.s = true;
            this.n = true;
            this.scanPlayers(list);
        }
        if (this.v != this.tracker.vehicle) {
            this.v = this.tracker.vehicle;
            this.broadcast(new Packet39AttachEntity(this.tracker, this.tracker.vehicle));
        }
        if (this.tracker.vehicle == null) {
            ++this.u;
            if (this.m++ % this.c == 0 || this.tracker.al) {
                int n;
                DataWatcher dataWatcher;
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                boolean bl;
                int n2 = this.tracker.am.a(this.tracker.locX);
                int n3 = MathHelper.floor(this.tracker.locY * 32.0);
                int n4 = this.tracker.am.a(this.tracker.locZ);
                int n5 = MathHelper.d(this.tracker.yaw * 256.0f / 360.0f);
                int n6 = MathHelper.d(this.tracker.pitch * 256.0f / 360.0f);
                int n7 = n2 - this.xLoc;
                int n8 = n3 - this.yLoc;
                int n9 = n4 - this.zLoc;
                Packet packet = null;
                boolean bl2 = Math.abs(n7) >= 4 || Math.abs(n8) >= 4 || Math.abs(n9) >= 4;
                boolean bl3 = bl = Math.abs(n5 - this.yRot) >= 4 || Math.abs(n6 - this.xRot) >= 4;
                if (n7 < -128 || n7 >= 128 || n8 < -128 || n8 >= 128 || n9 < -128 || n9 >= 128 || this.u > 400) {
                    this.u = 0;
                    packet = new Packet34EntityTeleport(this.tracker.id, n2, n3, n4, (byte)n5, (byte)n6);
                } else if (bl2 && bl) {
                    packet = new Packet33RelEntityMoveLook(this.tracker.id, (byte)n7, (byte)n8, (byte)n9, (byte)n5, (byte)n6);
                } else if (bl2) {
                    packet = new Packet31RelEntityMove(this.tracker.id, (byte)n7, (byte)n8, (byte)n9);
                } else if (bl) {
                    packet = new Packet32EntityLook(this.tracker.id, (byte)n5, (byte)n6);
                }
                if (this.isMoving && ((d5 = (d4 = this.tracker.motX - this.j) * d4 + (d3 = this.tracker.motY - this.k) * d3 + (d2 = this.tracker.motZ - this.l) * d2) > (d = 0.02) * d || d5 > 0.0 && this.tracker.motX == 0.0 && this.tracker.motY == 0.0 && this.tracker.motZ == 0.0)) {
                    this.j = this.tracker.motX;
                    this.k = this.tracker.motY;
                    this.l = this.tracker.motZ;
                    this.broadcast(new Packet28EntityVelocity(this.tracker.id, this.j, this.k, this.l));
                }
                if (packet != null) {
                    this.broadcast(packet);
                }
                if ((dataWatcher = this.tracker.getDataWatcher()).a()) {
                    this.broadcastIncludingSelf(new Packet40EntityMetadata(this.tracker.id, dataWatcher));
                }
                if (Math.abs((n = MathHelper.d(this.tracker.am() * 256.0f / 360.0f)) - this.i) >= 4) {
                    this.broadcast(new Packet35EntityHeadRotation(this.tracker.id, (byte)n));
                    this.i = n;
                }
                if (bl2) {
                    this.xLoc = n2;
                    this.yLoc = n3;
                    this.zLoc = n4;
                }
                if (bl) {
                    this.yRot = n5;
                    this.xRot = n6;
                }
            }
            this.tracker.al = false;
        }
        if (this.tracker.velocityChanged) {
            this.broadcastIncludingSelf(new Packet28EntityVelocity(this.tracker));
            this.tracker.velocityChanged = false;
        }
    }

    public void broadcast(Packet packet) {
        for (EntityPlayer entityPlayer : this.trackedPlayers) {
            entityPlayer.netServerHandler.sendPacket(packet);
        }
    }

    public void broadcastIncludingSelf(Packet packet) {
        this.broadcast(packet);
        if (this.tracker instanceof EntityPlayer) {
            ((EntityPlayer)this.tracker).netServerHandler.sendPacket(packet);
        }
    }

    public void a() {
        for (EntityPlayer entityPlayer : this.trackedPlayers) {
            entityPlayer.g.add(this.tracker.id);
        }
    }

    public void a(EntityPlayer entityPlayer) {
        if (this.trackedPlayers.contains(entityPlayer)) {
            this.trackedPlayers.remove(entityPlayer);
        }
    }

    public void updatePlayer(EntityPlayer entityPlayer) {
        if (entityPlayer == this.tracker) {
            return;
        }
        double d = entityPlayer.locX - (double)(this.xLoc / 32);
        double d2 = entityPlayer.locZ - (double)(this.zLoc / 32);
        if (d >= (double)(-this.b) && d <= (double)this.b && d2 >= (double)(-this.b) && d2 <= (double)this.b) {
            if (!this.trackedPlayers.contains(entityPlayer) && this.d(entityPlayer)) {
                EntityHuman entityHuman;
                ItemStack[] itemStackArray;
                this.trackedPlayers.add(entityPlayer);
                Packet packet = this.b();
                entityPlayer.netServerHandler.sendPacket(packet);
                this.j = this.tracker.motX;
                this.k = this.tracker.motY;
                this.l = this.tracker.motZ;
                if (this.isMoving && !(packet instanceof Packet24MobSpawn)) {
                    entityPlayer.netServerHandler.sendPacket(new Packet28EntityVelocity(this.tracker.id, this.tracker.motX, this.tracker.motY, this.tracker.motZ));
                }
                if (this.tracker.vehicle != null) {
                    entityPlayer.netServerHandler.sendPacket(new Packet39AttachEntity(this.tracker, this.tracker.vehicle));
                }
                if ((itemStackArray = this.tracker.getEquipment()) != null) {
                    for (int i = 0; i < itemStackArray.length; ++i) {
                        entityPlayer.netServerHandler.sendPacket(new Packet5EntityEquipment(this.tracker.id, i, itemStackArray[i]));
                    }
                }
                if (this.tracker instanceof EntityHuman && (entityHuman = (EntityHuman)this.tracker).isSleeping()) {
                    entityPlayer.netServerHandler.sendPacket(new Packet17EntityLocationAction(this.tracker, 0, MathHelper.floor(this.tracker.locX), MathHelper.floor(this.tracker.locY), MathHelper.floor(this.tracker.locZ)));
                }
                if (this.tracker instanceof EntityLiving) {
                    EntityLiving entityLiving = (EntityLiving)this.tracker;
                    for (MobEffect mobEffect : entityLiving.getEffects()) {
                        entityPlayer.netServerHandler.sendPacket(new Packet41MobEffect(this.tracker.id, mobEffect));
                    }
                }
            }
        } else if (this.trackedPlayers.contains(entityPlayer)) {
            this.trackedPlayers.remove(entityPlayer);
            entityPlayer.g.add(this.tracker.id);
        }
    }

    private boolean d(EntityPlayer entityPlayer) {
        return entityPlayer.q().getPlayerManager().a(entityPlayer, this.tracker.ah, this.tracker.aj);
    }

    public void scanPlayers(List list) {
        for (EntityHuman entityHuman : list) {
            this.updatePlayer((EntityPlayer)entityHuman);
        }
    }

    private Packet b() {
        Entity entity;
        if (this.tracker.dead) {
            System.out.println("Fetching addPacket for removed entity");
        }
        if (this.tracker instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)this.tracker;
            Packet21PickupSpawn packet21PickupSpawn = new Packet21PickupSpawn(entityItem);
            entityItem.locX = (double)packet21PickupSpawn.b / 32.0;
            entityItem.locY = (double)packet21PickupSpawn.c / 32.0;
            entityItem.locZ = (double)packet21PickupSpawn.d / 32.0;
            return packet21PickupSpawn;
        }
        if (this.tracker instanceof EntityPlayer) {
            return new Packet20NamedEntitySpawn((EntityHuman)this.tracker);
        }
        if (this.tracker instanceof EntityMinecart) {
            entity = (EntityMinecart)this.tracker;
            if (entity.type == 0) {
                return new Packet23VehicleSpawn(this.tracker, 10);
            }
            if (entity.type == 1) {
                return new Packet23VehicleSpawn(this.tracker, 11);
            }
            if (entity.type == 2) {
                return new Packet23VehicleSpawn(this.tracker, 12);
            }
        }
        if (this.tracker instanceof EntityBoat) {
            return new Packet23VehicleSpawn(this.tracker, 1);
        }
        if (this.tracker instanceof IAnimal || this.tracker instanceof EntityEnderDragon) {
            this.i = MathHelper.d(this.tracker.am() * 256.0f / 360.0f);
            return new Packet24MobSpawn((EntityLiving)this.tracker);
        }
        if (this.tracker instanceof EntityFishingHook) {
            entity = ((EntityFishingHook)this.tracker).owner;
            return new Packet23VehicleSpawn(this.tracker, 90, entity != null ? entity.id : this.tracker.id);
        }
        if (this.tracker instanceof EntityArrow) {
            entity = ((EntityArrow)this.tracker).shooter;
            return new Packet23VehicleSpawn(this.tracker, 60, entity != null ? entity.id : this.tracker.id);
        }
        if (this.tracker instanceof EntitySnowball) {
            return new Packet23VehicleSpawn(this.tracker, 61);
        }
        if (this.tracker instanceof EntityPotion) {
            return new Packet23VehicleSpawn(this.tracker, 73, ((EntityPotion)this.tracker).getPotionValue());
        }
        if (this.tracker instanceof EntityThrownExpBottle) {
            return new Packet23VehicleSpawn(this.tracker, 75);
        }
        if (this.tracker instanceof EntityEnderPearl) {
            return new Packet23VehicleSpawn(this.tracker, 65);
        }
        if (this.tracker instanceof EntityEnderSignal) {
            return new Packet23VehicleSpawn(this.tracker, 72);
        }
        if (this.tracker instanceof EntitySmallFireball) {
            entity = (EntitySmallFireball)this.tracker;
            Packet23VehicleSpawn packet23VehicleSpawn = null;
            packet23VehicleSpawn = ((EntitySmallFireball)entity).shooter != null ? new Packet23VehicleSpawn(this.tracker, 64, ((EntitySmallFireball)entity).shooter.id) : new Packet23VehicleSpawn(this.tracker, 64, 0);
            packet23VehicleSpawn.e = (int)(((EntitySmallFireball)entity).dirX * 8000.0);
            packet23VehicleSpawn.f = (int)(((EntitySmallFireball)entity).dirY * 8000.0);
            packet23VehicleSpawn.g = (int)(((EntitySmallFireball)entity).dirZ * 8000.0);
            return packet23VehicleSpawn;
        }
        if (this.tracker instanceof EntityFireball) {
            entity = (EntityFireball)this.tracker;
            Packet23VehicleSpawn packet23VehicleSpawn = null;
            packet23VehicleSpawn = ((EntityFireball)entity).shooter != null ? new Packet23VehicleSpawn(this.tracker, 63, ((EntityFireball)this.tracker).shooter.id) : new Packet23VehicleSpawn(this.tracker, 63, 0);
            packet23VehicleSpawn.e = (int)(((EntityFireball)entity).dirX * 8000.0);
            packet23VehicleSpawn.f = (int)(((EntityFireball)entity).dirY * 8000.0);
            packet23VehicleSpawn.g = (int)(((EntityFireball)entity).dirZ * 8000.0);
            return packet23VehicleSpawn;
        }
        if (this.tracker instanceof EntityEgg) {
            return new Packet23VehicleSpawn(this.tracker, 62);
        }
        if (this.tracker instanceof EntityTNTPrimed) {
            return new Packet23VehicleSpawn(this.tracker, 50);
        }
        if (this.tracker instanceof EntityEnderCrystal) {
            return new Packet23VehicleSpawn(this.tracker, 51);
        }
        if (this.tracker instanceof EntityFallingBlock) {
            entity = (EntityFallingBlock)this.tracker;
            return new Packet23VehicleSpawn(this.tracker, 70, ((EntityFallingBlock)entity).id | ((EntityFallingBlock)entity).data << 16);
        }
        if (this.tracker instanceof EntityPainting) {
            return new Packet25EntityPainting((EntityPainting)this.tracker);
        }
        if (this.tracker instanceof EntityExperienceOrb) {
            return new Packet26AddExpOrb((EntityExperienceOrb)this.tracker);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.tracker.getClass() + "!");
    }

    public void clear(EntityPlayer entityPlayer) {
        if (this.trackedPlayers.contains(entityPlayer)) {
            this.trackedPlayers.remove(entityPlayer);
            entityPlayer.g.add(this.tracker.id);
        }
    }
}

