/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.BlockMinecartTrack;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.EntityThrownExpBottle;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBucket;
import net.minecraft.server.ItemMinecart;
import net.minecraft.server.ItemMonsterEgg;
import net.minecraft.server.ItemPotion;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.World;

public class BlockDispenser
extends BlockContainer {
    private Random a = new Random();

    protected BlockDispenser(int n) {
        super(n, Material.STONE);
        this.textureId = 45;
        this.a(CreativeModeTab.d);
    }

    public int p_() {
        return 4;
    }

    public int getDropType(int n, Random random, int n2) {
        return Block.DISPENSER.id;
    }

    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        this.l(world, n, n2, n3);
    }

    private void l(World world, int n, int n2, int n3) {
        if (world.isStatic) {
            return;
        }
        int n4 = world.getTypeId(n, n2, n3 - 1);
        int n5 = world.getTypeId(n, n2, n3 + 1);
        int n6 = world.getTypeId(n - 1, n2, n3);
        int n7 = world.getTypeId(n + 1, n2, n3);
        int n8 = 3;
        if (Block.n[n4] && !Block.n[n5]) {
            n8 = 3;
        }
        if (Block.n[n5] && !Block.n[n4]) {
            n8 = 2;
        }
        if (Block.n[n6] && !Block.n[n7]) {
            n8 = 5;
        }
        if (Block.n[n7] && !Block.n[n6]) {
            n8 = 4;
        }
        world.setData(n, n2, n3, n8);
    }

    public int a(int n) {
        if (n == 1) {
            return this.textureId + 17;
        }
        if (n == 0) {
            return this.textureId + 17;
        }
        if (n == 3) {
            return this.textureId + 1;
        }
        return this.textureId;
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (world.isStatic) {
            return true;
        }
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        if (tileEntityDispenser != null) {
            entityHuman.openDispenser(tileEntityDispenser);
        }
        return true;
    }

    private void dispense(World world, int n, int n2, int n3, Random random) {
        int n4 = world.getData(n, n2, n3);
        int n5 = 0;
        int n6 = 0;
        if (n4 == 3) {
            n6 = 1;
        } else if (n4 == 2) {
            n6 = -1;
        } else {
            n5 = n4 == 5 ? 1 : -1;
        }
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        if (tileEntityDispenser != null) {
            int n7 = tileEntityDispenser.i();
            if (n7 < 0) {
                world.triggerEffect(1001, n, n2, n3, 0);
            } else {
                double d = (double)n + (double)n5 * 0.6 + 0.5;
                double d2 = (double)n2 + 0.5;
                double d3 = (double)n3 + (double)n6 * 0.6 + 0.5;
                ItemStack itemStack = tileEntityDispenser.getItem(n7);
                int n8 = BlockDispenser.a(tileEntityDispenser, world, itemStack, random, n, n2, n3, n5, n6, d, d2, d3);
                if (n8 == 1) {
                    tileEntityDispenser.splitStack(n7, 1);
                } else if (n8 == 0) {
                    itemStack = tileEntityDispenser.splitStack(n7, 1);
                    BlockDispenser.a(world, itemStack, random, 6, n5, n6, d, d2, d3);
                    world.triggerEffect(1000, n, n2, n3, 0);
                }
                world.triggerEffect(2000, n, n2, n3, n5 + 1 + (n6 + 1) * 3);
            }
        }
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Block.byId[n4].isPowerSource()) {
            boolean bl;
            boolean bl2 = bl = world.isBlockIndirectlyPowered(n, n2, n3) || world.isBlockIndirectlyPowered(n, n2 + 1, n3);
            if (bl) {
                world.a(n, n2, n3, this.id, this.p_());
            }
        }
    }

    public void b(World world, int n, int n2, int n3, Random random) {
        if (!world.isStatic && (world.isBlockIndirectlyPowered(n, n2, n3) || world.isBlockIndirectlyPowered(n, n2 + 1, n3))) {
            this.dispense(world, n, n2, n3, random);
        }
    }

    public TileEntity a(World world) {
        return new TileEntityDispenser();
    }

    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving) {
        int n4 = MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3;
        if (n4 == 0) {
            world.setData(n, n2, n3, 2);
        }
        if (n4 == 1) {
            world.setData(n, n2, n3, 5);
        }
        if (n4 == 2) {
            world.setData(n, n2, n3, 3);
        }
        if (n4 == 3) {
            world.setData(n, n2, n3, 4);
        }
    }

    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        if (tileEntityDispenser != null) {
            for (int i = 0; i < tileEntityDispenser.getSize(); ++i) {
                ItemStack itemStack = tileEntityDispenser.getItem(i);
                if (itemStack == null) continue;
                float f = this.a.nextFloat() * 0.8f + 0.1f;
                float f2 = this.a.nextFloat() * 0.8f + 0.1f;
                float f3 = this.a.nextFloat() * 0.8f + 0.1f;
                while (itemStack.count > 0) {
                    int n6 = this.a.nextInt(21) + 10;
                    if (n6 > itemStack.count) {
                        n6 = itemStack.count;
                    }
                    itemStack.count -= n6;
                    EntityItem entityItem = new EntityItem(world, (float)n + f, (float)n2 + f2, (float)n3 + f3, new ItemStack(itemStack.id, n6, itemStack.getData()));
                    if (itemStack.hasTag()) {
                        entityItem.itemStack.setTag((NBTTagCompound)itemStack.getTag().clone());
                    }
                    float f4 = 0.05f;
                    entityItem.motX = (float)this.a.nextGaussian() * f4;
                    entityItem.motY = (float)this.a.nextGaussian() * f4 + 0.2f;
                    entityItem.motZ = (float)this.a.nextGaussian() * f4;
                    world.addEntity(entityItem);
                }
            }
        }
        super.remove(world, n, n2, n3, n4, n5);
    }

    private static void a(World world, ItemStack itemStack, Random random, int n, int n2, int n3, double d, double d2, double d3) {
        EntityItem entityItem = new EntityItem(world, d, d2 - 0.3, d3, itemStack);
        double d4 = random.nextDouble() * 0.1 + 0.2;
        entityItem.motX = (double)n2 * d4;
        entityItem.motY = 0.2f;
        entityItem.motZ = (double)n3 * d4;
        entityItem.motX += random.nextGaussian() * (double)0.0075f * (double)n;
        entityItem.motY += random.nextGaussian() * (double)0.0075f * (double)n;
        entityItem.motZ += random.nextGaussian() * (double)0.0075f * (double)n;
        world.addEntity(entityItem);
    }

    private static int a(TileEntityDispenser tileEntityDispenser, World world, ItemStack itemStack, Random random, int n, int n2, int n3, int n4, int n5, double d, double d2, double d3) {
        float f = 1.1f;
        int n6 = 6;
        if (itemStack.id == Item.ARROW.id) {
            EntityArrow entityArrow = new EntityArrow(world, d, d2, d3);
            entityArrow.shoot(n4, 0.1f, n5, f, n6);
            entityArrow.fromPlayer = 1;
            world.addEntity(entityArrow);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.EGG.id) {
            EntityEgg entityEgg = new EntityEgg(world, d, d2, d3);
            entityEgg.c(n4, 0.1f, n5, f, n6);
            world.addEntity(entityEgg);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.SNOW_BALL.id) {
            EntitySnowball entitySnowball = new EntitySnowball(world, d, d2, d3);
            entitySnowball.c(n4, 0.1f, n5, f, n6);
            world.addEntity(entitySnowball);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.POTION.id && ItemPotion.g(itemStack.getData())) {
            EntityPotion entityPotion = new EntityPotion(world, d, d2, d3, itemStack.getData());
            entityPotion.c(n4, 0.1f, n5, f * 1.25f, (float)n6 * 0.5f);
            world.addEntity(entityPotion);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.EXP_BOTTLE.id) {
            EntityThrownExpBottle entityThrownExpBottle = new EntityThrownExpBottle(world, d, d2, d3);
            entityThrownExpBottle.c(n4, 0.1f, n5, f * 1.25f, (float)n6 * 0.5f);
            world.addEntity(entityThrownExpBottle);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.MONSTER_EGG.id) {
            ItemMonsterEgg.a(world, itemStack.getData(), d + (double)n4 * 0.3, d2 - 0.3, d3 + (double)n5 * 0.3);
            world.triggerEffect(1002, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.FIREBALL.id) {
            EntitySmallFireball entitySmallFireball = new EntitySmallFireball(world, d + (double)n4 * 0.3, d2, d3 + (double)n5 * 0.3, (double)n4 + random.nextGaussian() * 0.05, random.nextGaussian() * 0.05, (double)n5 + random.nextGaussian() * 0.05);
            world.addEntity(entitySmallFireball);
            world.triggerEffect(1009, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.LAVA_BUCKET.id || itemStack.id == Item.WATER_BUCKET.id) {
            ItemBucket itemBucket = (ItemBucket)itemStack.getItem();
            if (itemBucket.a(world, n, (double)n2, (double)n3, n + n4, n2, n3 + n5)) {
                itemStack.id = Item.BUCKET.id;
                itemStack.count = 1;
                return 2;
            }
            return 0;
        }
        if (itemStack.id == Item.BUCKET.id) {
            int n7 = n + n4;
            int n8 = n3 + n5;
            Material material = world.getMaterial(n7, n2, n8);
            int n9 = world.getData(n7, n2, n8);
            if (material == Material.WATER && n9 == 0) {
                world.setTypeId(n7, n2, n8, 0);
                if (--itemStack.count == 0) {
                    itemStack.id = Item.WATER_BUCKET.id;
                    itemStack.count = 1;
                } else if (tileEntityDispenser.a(new ItemStack(Item.WATER_BUCKET)) < 0) {
                    BlockDispenser.a(world, new ItemStack(Item.WATER_BUCKET), random, 6, n4, n5, d, d2, d3);
                }
                return 2;
            }
            if (material == Material.LAVA && n9 == 0) {
                world.setTypeId(n7, n2, n8, 0);
                if (--itemStack.count == 0) {
                    itemStack.id = Item.LAVA_BUCKET.id;
                    itemStack.count = 1;
                } else if (tileEntityDispenser.a(new ItemStack(Item.LAVA_BUCKET)) < 0) {
                    BlockDispenser.a(world, new ItemStack(Item.LAVA_BUCKET), random, 6, n4, n5, d, d2, d3);
                }
                return 2;
            }
            return 0;
        }
        if (itemStack.getItem() instanceof ItemMinecart) {
            d = (double)n + (n4 < 0 ? (double)n4 * 0.8 : (double)((float)n4 * 1.8f)) + (double)((float)Math.abs(n5) * 0.5f);
            d3 = (double)n3 + (n5 < 0 ? (double)n5 * 0.8 : (double)((float)n5 * 1.8f)) + (double)((float)Math.abs(n4) * 0.5f);
            if (BlockMinecartTrack.d_(world, n + n4, n2, n3 + n5)) {
                d2 = (float)n2 + 0.5f;
            } else if (world.isEmpty(n + n4, n2, n3 + n5) && BlockMinecartTrack.d_(world, n + n4, n2 - 1, n3 + n5)) {
                d2 = (float)n2 - 0.5f;
            } else {
                return 0;
            }
            EntityMinecart entityMinecart = new EntityMinecart(world, d, d2, d3, ((ItemMinecart)itemStack.getItem()).a);
            world.addEntity(entityMinecart);
            world.triggerEffect(1000, n, n2, n3, 0);
            return 1;
        }
        if (itemStack.id == Item.BOAT.id) {
            d = (double)n + (n4 < 0 ? (double)n4 * 0.8 : (double)((float)n4 * 1.8f)) + (double)((float)Math.abs(n5) * 0.5f);
            d3 = (double)n3 + (n5 < 0 ? (double)n5 * 0.8 : (double)((float)n5 * 1.8f)) + (double)((float)Math.abs(n4) * 0.5f);
            if (world.getMaterial(n + n4, n2, n3 + n5) == Material.WATER) {
                d2 = (float)n2 + 1.0f;
            } else if (world.isEmpty(n + n4, n2, n3 + n5) && world.getMaterial(n + n4, n2 - 1, n3 + n5) == Material.WATER) {
                d2 = n2;
            } else {
                return 0;
            }
            EntityBoat entityBoat = new EntityBoat(world, d, d2, d3);
            world.addEntity(entityBoat);
            world.triggerEffect(1000, n, n2, n3, 0);
            return 1;
        }
        return 0;
    }
}

