/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.IMerchant;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MerchantRecipe;
import net.minecraft.server.MerchantRecipeList;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NPC;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalInteract;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.server.PathfinderGoalMakeLove;
import net.minecraft.server.PathfinderGoalMoveIndoors;
import net.minecraft.server.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.PathfinderGoalOpenDoor;
import net.minecraft.server.PathfinderGoalPlay;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRestrictOpenDoor;
import net.minecraft.server.PathfinderGoalTakeFlower;
import net.minecraft.server.PathfinderGoalTradeWithPlayer;
import net.minecraft.server.Tuple;
import net.minecraft.server.Village;
import net.minecraft.server.World;

public class EntityVillager
extends EntityAgeable
implements NPC,
IMerchant {
    private int profession = 0;
    private boolean f = false;
    private boolean g = false;
    Village village = null;
    private EntityHuman h;
    private MerchantRecipeList i;
    private int j;
    private boolean by;
    private int bz;
    private MerchantRecipe bA;
    private static final Map bB = new HashMap();
    private static final Map bC = new HashMap();

    public EntityVillager(World world) {
        this(world, 0);
    }

    public EntityVillager(World world, int n) {
        super(world);
        this.setProfession(n);
        this.texture = "/mob/villager/villager.png";
        this.bw = 0.5f;
        this.getNavigation().b(true);
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalAvoidPlayer(this, EntityZombie.class, 8.0f, 0.3f, 0.35f));
        this.goalSelector.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.goalSelector.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.goalSelector.a(2, new PathfinderGoalMoveIndoors(this));
        this.goalSelector.a(3, new PathfinderGoalRestrictOpenDoor(this));
        this.goalSelector.a(4, new PathfinderGoalOpenDoor(this, true));
        this.goalSelector.a(5, new PathfinderGoalMoveTowardsRestriction(this, 0.3f));
        this.goalSelector.a(6, new PathfinderGoalMakeLove(this));
        this.goalSelector.a(7, new PathfinderGoalTakeFlower(this));
        this.goalSelector.a(8, new PathfinderGoalPlay(this, 0.32f));
        this.goalSelector.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.a(9, new PathfinderGoalInteract(this, EntityVillager.class, 5.0f, 0.02f));
        this.goalSelector.a(9, new PathfinderGoalRandomStroll(this, 0.3f));
        this.goalSelector.a(10, new PathfinderGoalLookAtPlayer(this, EntityLiving.class, 8.0f));
    }

    public boolean aV() {
        return true;
    }

    protected void bd() {
        if (--this.profession <= 0) {
            this.world.villages.a(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.profession = 70 + this.random.nextInt(50);
            this.village = this.world.villages.getClosestVillage(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ), 32);
            if (this.village == null) {
                this.aE();
            } else {
                ChunkCoordinates chunkCoordinates = this.village.getCenter();
                this.b(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, this.village.getSize());
            }
        }
        if (!this.q() && this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                if (this.by) {
                    this.c(1);
                    this.by = false;
                }
                if (this.bA != null) {
                    this.i.remove(this.bA);
                    this.bA = null;
                }
                this.addEffect(new MobEffect(MobEffectList.REGENERATION.id, 200, 0));
            }
        }
        super.bd();
    }

    public boolean c(EntityHuman entityHuman) {
        if (this.isAlive() && !this.q() && !this.isBaby()) {
            if (!this.world.isStatic) {
                this.a_(entityHuman);
                entityHuman.openTrade(this);
            }
            return true;
        }
        return super.c(entityHuman);
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, 0);
    }

    public int getMaxHealth() {
        return 20;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("Profession", this.getProfession());
        nBTTagCompound.setInt("Riches", this.bz);
        if (this.i != null) {
            nBTTagCompound.setCompound("Offers", this.i.a());
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setProfession(nBTTagCompound.getInt("Profession"));
        this.bz = nBTTagCompound.getInt("Riches");
        if (nBTTagCompound.hasKey("Offers")) {
            NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Offers");
            this.i = new MerchantRecipeList(nBTTagCompound2);
        }
    }

    protected boolean ba() {
        return false;
    }

    protected String aQ() {
        return "mob.villager.default";
    }

    protected String aR() {
        return "mob.villager.defaulthurt";
    }

    protected String aS() {
        return "mob.villager.defaultdeath";
    }

    public void setProfession(int n) {
        this.datawatcher.watch(16, n);
    }

    public int getProfession() {
        return this.datawatcher.getInt(16);
    }

    public boolean o() {
        return this.f;
    }

    public void e(boolean bl) {
        this.f = bl;
    }

    public void f(boolean bl) {
        this.g = bl;
    }

    public boolean p() {
        return this.g;
    }

    public void c(EntityLiving entityLiving) {
        super.c(entityLiving);
        if (this.village != null && entityLiving != null) {
            this.village.a(entityLiving);
        }
    }

    public void a_(EntityHuman entityHuman) {
        this.h = entityHuman;
    }

    public EntityHuman l_() {
        return this.h;
    }

    public boolean q() {
        return this.h != null;
    }

    public void a(MerchantRecipe merchantRecipe) {
        int n;
        merchantRecipe.f();
        if (merchantRecipe.a((MerchantRecipe)this.i.get(this.i.size() - 1))) {
            this.j = 60;
            this.by = true;
        } else if (this.i.size() > 1 && (n = this.random.nextInt(6) + this.random.nextInt(6) + 3) <= merchantRecipe.getUses()) {
            this.j = 20;
            this.bA = merchantRecipe;
        }
        if (merchantRecipe.getBuyItem1().id == Item.EMERALD.id) {
            this.bz += merchantRecipe.getBuyItem1().count;
        }
    }

    public MerchantRecipeList getOffers(EntityHuman entityHuman) {
        if (this.i == null) {
            this.c(1);
        }
        return this.i;
    }

    private void c(int n) {
        MerchantRecipeList merchantRecipeList = new MerchantRecipeList();
        switch (this.getProfession()) {
            case 0: {
                EntityVillager.a(merchantRecipeList, Item.WHEAT.id, this.random, 0.9f);
                EntityVillager.a(merchantRecipeList, Block.WOOL.id, this.random, 0.5f);
                EntityVillager.a(merchantRecipeList, Item.RAW_CHICKEN.id, this.random, 0.5f);
                EntityVillager.a(merchantRecipeList, Item.COOKED_FISH.id, this.random, 0.4f);
                EntityVillager.b(merchantRecipeList, Item.BREAD.id, this.random, 0.9f);
                EntityVillager.b(merchantRecipeList, Item.MELON.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.APPLE.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.COOKIE.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.SHEARS.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.FLINT_AND_STEEL.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.COOKED_CHICKEN.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.ARROW.id, this.random, 0.5f);
                if (!(this.random.nextFloat() < 0.5f)) break;
                merchantRecipeList.add(new MerchantRecipe(new ItemStack(Block.GRAVEL, 10), new ItemStack(Item.EMERALD), new ItemStack(Item.FLINT.id, 2 + this.random.nextInt(2), 0)));
                break;
            }
            case 4: {
                EntityVillager.a(merchantRecipeList, Item.COAL.id, this.random, 0.7f);
                EntityVillager.a(merchantRecipeList, Item.PORK.id, this.random, 0.5f);
                EntityVillager.a(merchantRecipeList, Item.RAW_BEEF.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.SADDLE.id, this.random, 0.1f);
                EntityVillager.b(merchantRecipeList, Item.LEATHER_CHESTPLATE.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.LEATHER_BOOTS.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.LEATHER_HELMET.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.LEATHER_LEGGINGS.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.GRILLED_PORK.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.COOKED_BEEF.id, this.random, 0.3f);
                break;
            }
            case 3: {
                EntityVillager.a(merchantRecipeList, Item.COAL.id, this.random, 0.7f);
                EntityVillager.a(merchantRecipeList, Item.IRON_INGOT.id, this.random, 0.5f);
                EntityVillager.a(merchantRecipeList, Item.GOLD_INGOT.id, this.random, 0.5f);
                EntityVillager.a(merchantRecipeList, Item.DIAMOND.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.IRON_SWORD.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_SWORD.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.IRON_AXE.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_AXE.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.IRON_PICKAXE.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_PICKAXE.id, this.random, 0.5f);
                EntityVillager.b(merchantRecipeList, Item.IRON_SPADE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_SPADE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.IRON_HOE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_HOE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.IRON_BOOTS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_BOOTS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.IRON_HELMET.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_HELMET.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.IRON_CHESTPLATE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_CHESTPLATE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.IRON_LEGGINGS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_LEGGINGS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_BOOTS.id, this.random, 0.1f);
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_HELMET.id, this.random, 0.1f);
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_CHESTPLATE.id, this.random, 0.1f);
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_LEGGINGS.id, this.random, 0.1f);
                break;
            }
            case 1: {
                EntityVillager.a(merchantRecipeList, Item.PAPER.id, this.random, 0.8f);
                EntityVillager.a(merchantRecipeList, Item.BOOK.id, this.random, 0.8f);
                EntityVillager.a(merchantRecipeList, Item.WRITTEN_BOOK.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Block.BOOKSHELF.id, this.random, 0.8f);
                EntityVillager.b(merchantRecipeList, Block.GLASS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.COMPASS.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.WATCH.id, this.random, 0.2f);
                break;
            }
            case 2: {
                int[] nArray;
                EntityVillager.b(merchantRecipeList, Item.EYE_OF_ENDER.id, this.random, 0.3f);
                EntityVillager.b(merchantRecipeList, Item.EXP_BOTTLE.id, this.random, 0.2f);
                EntityVillager.b(merchantRecipeList, Item.REDSTONE.id, this.random, 0.4f);
                EntityVillager.b(merchantRecipeList, Block.GLOWSTONE.id, this.random, 0.3f);
                for (int n2 : nArray = new int[]{Item.IRON_SWORD.id, Item.DIAMOND_SWORD.id, Item.IRON_CHESTPLATE.id, Item.DIAMOND_CHESTPLATE.id, Item.IRON_AXE.id, Item.DIAMOND_AXE.id, Item.IRON_PICKAXE.id, Item.DIAMOND_PICKAXE.id}) {
                    if (!(this.random.nextFloat() < 0.1f)) continue;
                    merchantRecipeList.add(new MerchantRecipe(new ItemStack(n2, 1, 0), new ItemStack(Item.EMERALD, 2 + this.random.nextInt(3), 0), EnchantmentManager.a(this.random, new ItemStack(n2, 1, 0), 5 + this.random.nextInt(15))));
                }
                break;
            }
        }
        if (merchantRecipeList.isEmpty()) {
            EntityVillager.a(merchantRecipeList, Item.GOLD_INGOT.id, this.random, 1.0f);
        }
        Collections.shuffle(merchantRecipeList);
        if (this.i == null) {
            this.i = new MerchantRecipeList();
        }
        for (int i = 0; i < n && i < merchantRecipeList.size(); ++i) {
            this.i.a((MerchantRecipe)merchantRecipeList.get(i));
        }
    }

    private static void a(MerchantRecipeList merchantRecipeList, int n, Random random, float f) {
        if (random.nextFloat() < f) {
            merchantRecipeList.add(new MerchantRecipe(EntityVillager.a(n, random), Item.EMERALD));
        }
    }

    private static ItemStack a(int n, Random random) {
        return new ItemStack(n, EntityVillager.b(n, random), 0);
    }

    private static int b(int n, Random random) {
        Tuple tuple = (Tuple)bB.get(n);
        if (tuple == null) {
            return 1;
        }
        if ((Integer)tuple.a() >= (Integer)tuple.b()) {
            return (Integer)tuple.a();
        }
        return (Integer)tuple.a() + random.nextInt((Integer)tuple.b() - (Integer)tuple.a());
    }

    private static void b(MerchantRecipeList merchantRecipeList, int n, Random random, float f) {
        if (random.nextFloat() < f) {
            ItemStack itemStack;
            ItemStack itemStack2;
            int n2 = EntityVillager.c(n, random);
            if (n2 < 0) {
                itemStack2 = new ItemStack(Item.EMERALD.id, 1, 0);
                itemStack = new ItemStack(n, -n2, 0);
            } else {
                itemStack2 = new ItemStack(Item.EMERALD.id, n2, 0);
                itemStack = new ItemStack(n, 1, 0);
            }
            merchantRecipeList.add(new MerchantRecipe(itemStack2, itemStack));
        }
    }

    private static int c(int n, Random random) {
        Tuple tuple = (Tuple)bC.get(n);
        if (tuple == null) {
            return 1;
        }
        if ((Integer)tuple.a() >= (Integer)tuple.b()) {
            return (Integer)tuple.a();
        }
        return (Integer)tuple.a() + random.nextInt((Integer)tuple.b() - (Integer)tuple.a());
    }

    static {
        bB.put(Item.COAL.id, new Tuple(16, 24));
        bB.put(Item.IRON_INGOT.id, new Tuple(8, 10));
        bB.put(Item.GOLD_INGOT.id, new Tuple(8, 10));
        bB.put(Item.DIAMOND.id, new Tuple(4, 6));
        bB.put(Item.PAPER.id, new Tuple(19, 30));
        bB.put(Item.BOOK.id, new Tuple(12, 15));
        bB.put(Item.WRITTEN_BOOK.id, new Tuple(1, 1));
        bB.put(Item.ENDER_PEARL.id, new Tuple(3, 4));
        bB.put(Item.EYE_OF_ENDER.id, new Tuple(2, 3));
        bB.put(Item.PORK.id, new Tuple(14, 18));
        bB.put(Item.RAW_BEEF.id, new Tuple(14, 18));
        bB.put(Item.RAW_CHICKEN.id, new Tuple(14, 18));
        bB.put(Item.COOKED_FISH.id, new Tuple(9, 13));
        bB.put(Item.SEEDS.id, new Tuple(34, 48));
        bB.put(Item.MELON_SEEDS.id, new Tuple(30, 38));
        bB.put(Item.PUMPKIN_SEEDS.id, new Tuple(30, 38));
        bB.put(Item.WHEAT.id, new Tuple(18, 22));
        bB.put(Block.WOOL.id, new Tuple(14, 22));
        bB.put(Item.ROTTEN_FLESH.id, new Tuple(36, 64));
        bC.put(Item.FLINT_AND_STEEL.id, new Tuple(3, 4));
        bC.put(Item.SHEARS.id, new Tuple(3, 4));
        bC.put(Item.IRON_SWORD.id, new Tuple(7, 11));
        bC.put(Item.DIAMOND_SWORD.id, new Tuple(12, 14));
        bC.put(Item.IRON_AXE.id, new Tuple(6, 8));
        bC.put(Item.DIAMOND_AXE.id, new Tuple(9, 12));
        bC.put(Item.IRON_PICKAXE.id, new Tuple(7, 9));
        bC.put(Item.DIAMOND_PICKAXE.id, new Tuple(10, 12));
        bC.put(Item.IRON_SPADE.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_SPADE.id, new Tuple(7, 8));
        bC.put(Item.IRON_HOE.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_HOE.id, new Tuple(7, 8));
        bC.put(Item.IRON_BOOTS.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_BOOTS.id, new Tuple(7, 8));
        bC.put(Item.IRON_HELMET.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_HELMET.id, new Tuple(7, 8));
        bC.put(Item.IRON_CHESTPLATE.id, new Tuple(10, 14));
        bC.put(Item.DIAMOND_CHESTPLATE.id, new Tuple(16, 19));
        bC.put(Item.IRON_LEGGINGS.id, new Tuple(8, 10));
        bC.put(Item.DIAMOND_LEGGINGS.id, new Tuple(11, 14));
        bC.put(Item.CHAINMAIL_BOOTS.id, new Tuple(5, 7));
        bC.put(Item.CHAINMAIL_HELMET.id, new Tuple(5, 7));
        bC.put(Item.CHAINMAIL_CHESTPLATE.id, new Tuple(11, 15));
        bC.put(Item.CHAINMAIL_LEGGINGS.id, new Tuple(9, 11));
        bC.put(Item.BREAD.id, new Tuple(-4, -2));
        bC.put(Item.MELON.id, new Tuple(-8, -4));
        bC.put(Item.APPLE.id, new Tuple(-8, -4));
        bC.put(Item.COOKIE.id, new Tuple(-10, -7));
        bC.put(Block.GLASS.id, new Tuple(-5, -3));
        bC.put(Block.BOOKSHELF.id, new Tuple(3, 4));
        bC.put(Item.LEATHER_CHESTPLATE.id, new Tuple(4, 5));
        bC.put(Item.LEATHER_BOOTS.id, new Tuple(2, 4));
        bC.put(Item.LEATHER_HELMET.id, new Tuple(2, 4));
        bC.put(Item.LEATHER_LEGGINGS.id, new Tuple(2, 4));
        bC.put(Item.SADDLE.id, new Tuple(6, 8));
        bC.put(Item.EXP_BOTTLE.id, new Tuple(-4, -1));
        bC.put(Item.REDSTONE.id, new Tuple(-4, -1));
        bC.put(Item.COMPASS.id, new Tuple(10, 12));
        bC.put(Item.WATCH.id, new Tuple(10, 12));
        bC.put(Block.GLOWSTONE.id, new Tuple(-3, -1));
        bC.put(Item.GRILLED_PORK.id, new Tuple(-7, -5));
        bC.put(Item.COOKED_BEEF.id, new Tuple(-7, -5));
        bC.put(Item.COOKED_CHICKEN.id, new Tuple(-8, -6));
        bC.put(Item.EYE_OF_ENDER.id, new Tuple(7, 11));
        bC.put(Item.ARROW.id, new Tuple(-5, -19));
    }
}

