/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels.general;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.spigotmc.gui.BuildToolsProcess;
import org.spigotmc.gui.attributes.Lockable;
import org.spigotmc.gui.data.BuildData;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.modals.DebugInfoModal;
import org.spigotmc.gui.modals.MessageModal;
import org.spigotmc.gui.panels.general.console.ConsolePane;
import org.spigotmc.gui.panels.general.console.ConsolePanelHeader;
import org.spigotmc.gui.panels.general.settings.SettingsPanel;
import org.spigotmc.gui.panels.general.settings.SettingsPanelHeader;
import org.spigotmc.gui.panels.general.settings.VersionWarningPane;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;
import org.spigotmc.utils.Utils;

public class GeneralPanel
extends JPanel
implements Lockable {
    private final JButton buildButton = new JButton();
    private final JButton copyLogButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton debugInfoButton = new JButton();
    private final JProgressBar progressBar = new JProgressBar();
    private SettingsPanel settingsPanel;
    private VersionWarningPane versionWarningPane;
    private ConsolePane consolePane;
    private ConsolePanelHeader consolePanelHeader;
    private final JFrame parent;
    private final BuildData buildData;
    private final BuildSettings buildSettings;
    private BuildToolsProcess buildProcess;

    public GeneralPanel(BuildData buildData, BuildSettings buildSettings, JFrame parent) {
        this.buildData = buildData;
        this.buildSettings = buildSettings;
        this.parent = parent;
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.setPreferredSize(new Dimension(1200, 700));
        this.initComponents();
    }

    private void initComponents() {
        this.consolePane = new ConsolePane();
        this.versionWarningPane = new VersionWarningPane();
        this.settingsPanel = new SettingsPanel(this.buildData, this.buildSettings, this.consolePane, this.versionWarningPane);
        SettingsPanelHeader settingsPanelHeader = new SettingsPanelHeader();
        this.consolePanelHeader = new ConsolePanelHeader();
        this.progressBar.setPreferredSize(new Dimension(146, 8));
        this.buildButton.setBackground(Constants.ACCENT_COLOR);
        this.buildButton.setForeground(new Color(255, 255, 255));
        this.buildButton.setText("Compile");
        this.buildButton.setToolTipText("Start");
        this.buildButton.setMargin(new Insets(8, 16, 8, 16));
        this.buildButton.addActionListener(this::buildButtonActionPerformed);
        this.buildButton.setCursor(Cursor.getPredefinedCursor(12));
        this.copyLogButton.setText("Copy Log");
        this.copyLogButton.setToolTipText("Copy the log to your clipboard.");
        this.copyLogButton.setMargin(new Insets(8, 16, 8, 16));
        this.copyLogButton.addActionListener(this::copyLogButtonActionPerformed);
        this.copyLogButton.setCursor(Cursor.getPredefinedCursor(12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Terminates the currently running compilation operation");
        this.cancelButton.setMargin(new Insets(8, 16, 8, 16));
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.cancelButton.setCursor(Cursor.getPredefinedCursor(12));
        this.cancelButton.setEnabled(false);
        this.debugInfoButton.setText("Debug Info");
        this.debugInfoButton.setToolTipText("View the debug panel.");
        this.debugInfoButton.setMargin(new Insets(8, 16, 8, 16));
        this.debugInfoButton.addActionListener(this::debugInfoButtonActionPerformed);
        this.debugInfoButton.setCursor(Cursor.getPredefinedCursor(12));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.debugInfoButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyLogButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildButton)).addComponent(settingsPanelHeader, -1, -1, Short.MAX_VALUE).addComponent(this.consolePane).addComponent(this.consolePanelHeader, -1, -1, Short.MAX_VALUE).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.progressBar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.versionWarningPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(settingsPanelHeader, -2, -1, -2).addGap(0, 0, 0).addComponent(this.settingsPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.versionWarningPane, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consolePanelHeader, -2, -1, -2).addGap(0, 0, 0).addComponent(this.consolePane, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 10, -2).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugInfoButton, -2, 32, -2).addComponent(this.cancelButton, -2, 32, -2).addComponent(this.copyLogButton, -2, 32, -2).addComponent(this.buildButton, -2, 32, -2))));
        this.setFocusCycleRoot(true);
    }

    private void buildButtonActionPerformed(ActionEvent event) {
        try {
            if (!this.buildData.updateJavaExecutable(this.buildSettings, true).get().booleanValue()) {
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            MessageModal.displayError(Utils.getReadableStacktrace(e));
            return;
        }
        this.cancelButton.setEnabled(true);
        this.consolePane.updateConsoleAreaText(new ArrayList<String>());
        this.progressBar.setIndeterminate(true);
        this.progressBar.setForeground(Constants.ACCENT_COLOR_DESATURATED);
        List<String> args = this.buildData.buildArgs(this.buildSettings);
        this.buildButton.setText("Compiling...");
        SwingUtils.toggleLockComponents(this.parent, Lockable.LockReason.BUILD);
        CompletableFuture.supplyAsync(() -> {
            Process process;
            this.consolePane.updateStreams();
            if (!this.buildSettings.getWorkDirectory().isEmpty() && this.buildSettings.getOutputDirectory().isEmpty()) {
                this.buildSettings.setOutputDirectory(this.buildSettings.getWorkDirectory());
            }
            this.buildProcess = new BuildToolsProcess(args, System.out, new File(this.buildSettings.getWorkDirectory()));
            try {
                process = this.buildProcess.execute();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                return process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((exitValue, throwable) -> {
            this.cancelButton.setEnabled(false);
            this.buildButton.setText("Compile");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setForeground(Constants.ACCENT_COLOR);
            this.progressBar.setValue(100);
            SwingUtils.toggleLockComponents(this.parent, Lockable.LockReason.BUILD);
            if (this.consolePanelHeader.copyLogsOnFinish()) {
                SwingUtils.copyToClipboard(new File("BuildTools.log.txt"));
            }
            if (throwable != null) {
                MessageModal.displayError(Utils.getReadableStacktrace(throwable));
                return;
            }
            if (exitValue == 2) {
                String style = Utils.getFileContentsFromResource("web/reset.css");
                String message = Utils.getFileContentsFromResource("web/success_no_compile.html");
                message = message.replace("%STYLESHEET%", "<style>" + style + "</style>");
                MessageModal.displaySuccess(message);
                return;
            }
            if (exitValue != 0) {
                MessageModal.displayError("Task exited with error code " + exitValue);
                return;
            }
            String style = Utils.getFileContentsFromResource("web/reset.css");
            String message = Utils.getFileContentsFromResource("web/success.html");
            message = message.replace("%STYLESHEET%", "<style>" + style + "</style>");
            message = message.replace("%OUTPUT_DIRECTORY%", new File(this.buildSettings.getOutputDirectory()).getAbsolutePath());
            message = message.replace("%PLUGINS_LINK%", "https://spigotmc.org/resources");
            MessageModal.displaySuccess(message);
            if (this.settingsPanel.getOutputDirField().getText().isEmpty()) {
                this.buildSettings.setOutputDirectory("");
            }
        });
    }

    private void debugInfoButtonActionPerformed(ActionEvent event) {
        DebugInfoModal debug = new DebugInfoModal(this.buildData, this.buildSettings);
        debug.setLocationRelativeTo(null);
        debug.setVisible(true);
    }

    private void copyLogButtonActionPerformed(ActionEvent event) {
        SwingUtils.copyToClipboard(new File("BuildTools.log.txt"));
        SwingUtils.buttonCooldown((AbstractButton)event.getSource(), 3, "Copied To Clipboard");
    }

    private void cancelButtonActionPerformed(ActionEvent event) {
        this.cancelButton.setEnabled(false);
        if (this.buildProcess == null || this.buildProcess.getProcess() == null) {
            return;
        }
        this.buildProcess.getProcess().destroy();
        System.out.println("Compilation terminated by the user");
    }

    public SettingsPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    public VersionWarningPane getVersionWarningPane() {
        return this.versionWarningPane;
    }

    public ConsolePane getConsolePane() {
        return this.consolePane;
    }

    @Override
    public void onLockToggle(Lockable.LockReason reason) {
        this.buildButton.setEnabled(!this.buildButton.isEnabled());
        this.debugInfoButton.setEnabled(!this.debugInfoButton.isEnabled());
        this.copyLogButton.setEnabled(!this.copyLogButton.isEnabled());
    }

    public BuildToolsProcess getBuildToolsProcess() {
        return this.buildProcess;
    }
}

