/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

public class ReceivedPackStatistics {

    public static class Builder {
        private long numBytesRead;
        private long numBytesDuplicated;
        private long numWholeCommit;
        private long numWholeTree;
        private long numWholeBlob;
        private long numWholeTag;
        private long numOfsDelta;
        private long numRefDelta;
        private long numObjectsDuplicated;
        private long numDeltaCommit;
        private long numDeltaTree;
        private long numDeltaBlob;
        private long numDeltaTag;

        public Builder setNumBytesRead(long numBytesRead) {
            this.numBytesRead = numBytesRead;
            return this;
        }

        Builder incrementNumBytesDuplicated(long size) {
            this.numBytesDuplicated += size;
            return this;
        }

        public Builder addWholeObject(int type) {
            switch (type) {
                case 1: {
                    ++this.numWholeCommit;
                    break;
                }
                case 2: {
                    ++this.numWholeTree;
                    break;
                }
                case 3: {
                    ++this.numWholeBlob;
                    break;
                }
                case 4: {
                    ++this.numWholeTag;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(type) + " cannot be a whole object");
                }
            }
            return this;
        }

        public Builder addOffsetDelta() {
            ++this.numOfsDelta;
            return this;
        }

        public Builder addRefDelta() {
            ++this.numRefDelta;
            return this;
        }

        Builder incrementObjectsDuplicated() {
            ++this.numObjectsDuplicated;
            return this;
        }

        public Builder addDeltaObject(int type) {
            switch (type) {
                case 1: {
                    ++this.numDeltaCommit;
                    break;
                }
                case 2: {
                    ++this.numDeltaTree;
                    break;
                }
                case 3: {
                    ++this.numDeltaBlob;
                    break;
                }
                case 4: {
                    ++this.numDeltaTag;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("delta should be a delta to a whole object. " + type + " cannot be a whole object");
                }
            }
            return this;
        }
    }
}

