/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class ReceiveCommand {
    private final ObjectId oldId;
    private final String oldSymref;
    private final ObjectId newId;
    private final String newSymref;
    private final String name;
    private Type type;
    private boolean typeIsCorrect;
    private Result status = Result.NOT_ATTEMPTED;
    private String message;
    private boolean customRefLog;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private Boolean forceRefLog;

    public static List<ReceiveCommand> filter(Iterable<ReceiveCommand> in, Result want) {
        ArrayList<ReceiveCommand> r = in instanceof Collection ? new ArrayList(((Collection)in).size()) : new ArrayList<ReceiveCommand>();
        for (ReceiveCommand cmd : in) {
            if (cmd.getResult() != want) continue;
            r.add(cmd);
        }
        return r;
    }

    public static List<ReceiveCommand> filter(List<ReceiveCommand> commands, Result want) {
        return ReceiveCommand.filter(commands, want);
    }

    public static void abort(Iterable<ReceiveCommand> commands) {
        for (ReceiveCommand c : commands) {
            if (c.getResult() != Result.NOT_ATTEMPTED) continue;
            c.setResult(Result.REJECTED_OTHER_REASON, JGitText.get().transactionAborted);
        }
    }

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name) {
        if (oldId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (newId == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = oldId;
        this.oldSymref = null;
        this.newId = newId;
        this.newSymref = null;
        this.name = name;
        this.type = Type.UPDATE;
        if (ObjectId.zeroId().equals(oldId)) {
            this.type = Type.CREATE;
        }
        if (ObjectId.zeroId().equals(newId)) {
            this.type = Type.DELETE;
        }
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    public String getOldSymref() {
        return this.oldSymref;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public String getNewSymref() {
        return this.newSymref;
    }

    public String getRefName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Result getResult() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasCustomRefLog() {
        return this.customRefLog;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public Boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public void setResult(Result s) {
        this.setResult(s, null);
    }

    public void setResult(Result s, String m) {
        this.status = s;
        this.message = m;
    }

    public void updateType(RevWalk walk) throws IOException {
        if (this.typeIsCorrect) {
            return;
        }
        if (this.type == Type.UPDATE && !AnyObjectId.isEqual(this.oldId, this.newId)) {
            RevObject o = walk.parseAny(this.oldId);
            RevObject n = walk.parseAny(this.newId);
            if (!(o instanceof RevCommit && n instanceof RevCommit && walk.isMergedInto((RevCommit)o, (RevCommit)n))) {
                this.setType(Type.UPDATE_NONFASTFORWARD);
            }
        }
        this.typeIsCorrect = true;
    }

    void setType(Type t) {
        this.type = t;
    }

    public void setResult(RefUpdate.Result r) {
        switch (r) {
            case NOT_ATTEMPTED: {
                this.setResult(Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                this.setResult(Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                this.setResult(Result.OK);
                break;
            }
            case REJECTED: {
                this.setResult(Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                this.setResult(Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            case REJECTED_MISSING_OBJECT: {
                this.setResult(Result.REJECTED_MISSING_OBJECT);
                break;
            }
            case REJECTED_OTHER_REASON: {
                this.setResult(Result.REJECTED_OTHER_REASON);
                break;
            }
            default: {
                this.setResult(Result.REJECTED_OTHER_REASON, r.name());
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getType().name()) + ": " + this.getOldId().name() + " " + this.getNewId().name() + " " + this.getRefName();
    }

    public static enum Result {
        NOT_ATTEMPTED,
        REJECTED_NOCREATE,
        REJECTED_NODELETE,
        REJECTED_NONFASTFORWARD,
        REJECTED_CURRENT_BRANCH,
        REJECTED_MISSING_OBJECT,
        REJECTED_OTHER_REASON,
        LOCK_FAILURE,
        OK;

    }

    public static enum Type {
        CREATE,
        UPDATE,
        UPDATE_NONFASTFORWARD,
        DELETE;

    }
}

