/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class SymbolicRef
implements Ref {
    private final String name;
    private final Ref target;
    private final long updateIndex;

    public SymbolicRef(String refName, Ref target) {
        this.name = refName;
        this.target = target;
        this.updateIndex = -1L;
    }

    public SymbolicRef(String refName, Ref target, long updateIndex) {
        this.name = refName;
        this.target = target;
        this.updateIndex = updateIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    @Override
    public Ref getLeaf() {
        Ref dst = this.getTarget();
        while (dst.isSymbolic()) {
            dst = dst.getTarget();
        }
        return dst;
    }

    @Override
    public Ref getTarget() {
        return this.target;
    }

    @Override
    public ObjectId getObjectId() {
        return this.getLeaf().getObjectId();
    }

    @Override
    public Ref.Storage getStorage() {
        return Ref.Storage.LOOSE;
    }

    @Override
    public ObjectId getPeeledObjectId() {
        return this.getLeaf().getPeeledObjectId();
    }

    @Override
    public boolean isPeeled() {
        return this.getLeaf().isPeeled();
    }

    @Override
    public long getUpdateIndex() {
        if (this.updateIndex == -1L) {
            throw new UnsupportedOperationException();
        }
        return this.updateIndex;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("SymbolicRef[");
        Ref cur = this;
        while (cur.isSymbolic()) {
            r.append(cur.getName());
            r.append(" -> ");
            cur = cur.getTarget();
        }
        r.append(cur.getName());
        r.append('=');
        r.append(ObjectId.toString(cur.getObjectId()));
        r.append("(");
        r.append(this.updateIndex);
        r.append(")]");
        return r.toString();
    }
}

