/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Delta;
import difflib.PatchFailedException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Patch {
    private List<Delta> deltas = new LinkedList<Delta>();
    private boolean isSorted = false;

    public List<?> applyTo(List<?> target) throws PatchFailedException {
        LinkedList<Object> result = new LinkedList<Object>(target);
        ListIterator<Delta> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public void addDelta(Delta delta) {
        this.deltas.add(delta);
        this.isSorted = false;
    }

    public List<Delta> getDeltas() {
        if (!this.isSorted) {
            Collections.sort(this.deltas, new Comparator<Delta>(){

                @Override
                public int compare(Delta d1, Delta d2) {
                    if (d1.getOriginal().getPosition() > d2.getOriginal().getPosition()) {
                        return 1;
                    }
                    if (d1.getOriginal().getPosition() > d2.getOriginal().getPosition()) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.isSorted = true;
        }
        return this.deltas;
    }
}

