/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

public class ChangeDelta
extends Delta {
    public ChangeDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        int i;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().getSize();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }
}

