/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutOutputStream(OutputStream destination, InterruptTimer timer) {
        this.dst = destination;
        this.myTimer = timer;
    }

    public void setTimeout(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, millis));
        }
        this.timeout = millis;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(b);
            }
            catch (InterruptedIOException e) {
                throw this.writeTimedOut(e);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(buf, off, len);
            }
            catch (InterruptedIOException e) {
                throw this.writeTimedOut(e);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.flush();
            }
            catch (InterruptedIOException e) {
                throw this.writeTimedOut(e);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.close();
            }
            catch (InterruptedIOException e) {
                throw this.writeTimedOut(e);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private void beginWrite() {
        this.myTimer.begin(this.timeout);
    }

    private void endWrite() {
        this.myTimer.end();
    }

    private InterruptedIOException writeTimedOut(InterruptedIOException cause) {
        InterruptedIOException e = new InterruptedIOException(MessageFormat.format(JGitText.get().writeTimedOut, this.timeout));
        e.initCause(cause);
        return e;
    }
}

