/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;

public abstract class CredentialItem {
    private final String promptText;
    private final boolean valueSecure;

    public CredentialItem(String promptText, boolean maskValue) {
        this.promptText = promptText;
        this.valueSecure = maskValue;
    }

    public static class CharArrayType
    extends CredentialItem {
        private char[] value;

        public CharArrayType(String promptText, boolean maskValue) {
            super(promptText, maskValue);
        }

        public void clear() {
            if (this.value != null) {
                Arrays.fill(this.value, '\u0000');
                this.value = null;
            }
        }

        public char[] getValue() {
            return this.value;
        }
    }

    public static class InformationalMessage
    extends CredentialItem {
        public InformationalMessage(String messageText) {
            super(messageText, false);
        }
    }

    public static class Password
    extends CharArrayType {
        public Password() {
            super(JGitText.get().credentialPassword, true);
        }
    }

    public static class StringType
    extends CredentialItem {
        private String value;

        public StringType(String promptText, boolean maskValue) {
            super(promptText, maskValue);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Username
    extends StringType {
        public Username() {
            super(JGitText.get().credentialUsername, false);
        }
    }

    public static class YesNoType
    extends CredentialItem {
        private boolean value;

        public YesNoType(String promptText) {
            super(promptText, false);
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

