/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels.general.console;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.PrintStream;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.spigotmc.builder.Builder;
import org.spigotmc.gui.components.TextAreaOutputStream;

public class ConsolePane
extends JScrollPane {
    private JTextArea consoleArea;

    public ConsolePane() {
        this.initComponents();
    }

    private void initComponents() {
        this.consoleArea = new JTextArea();
        this.consoleArea.setEditable(false);
        this.consoleArea.setColumns(1);
        this.consoleArea.setFont(new Font("Monospaced", 0, 12));
        this.consoleArea.setLineWrap(true);
        this.consoleArea.setRows(5);
        this.consoleArea.setWrapStyleWord(true);
        this.consoleArea.setMargin(new Insets(12, 12, 12, 12));
        this.setViewportView(this.consoleArea);
    }

    public void updateConsoleAreaText(List<String> lines) {
        this.consoleArea.setText("");
        for (String line : lines) {
            this.consoleArea.append(line + "\n");
        }
    }

    public String getConsoleText() {
        return this.consoleArea.getText();
    }

    public void updateStreams() {
        PrintStream outputStream = new PrintStream(new TextAreaOutputStream(this.consoleArea), true);
        PrintStream errorStream = new PrintStream(new TextAreaOutputStream(this.consoleArea, Color.RED), true);
        Builder.logOutput(outputStream, errorStream);
    }
}

