/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.modals;

import com.jeff_media.javafinder.JavaInstallation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.spigotmc.builder.Builder;
import org.spigotmc.builder.JavaVersion;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Themeable;
import org.spigotmc.gui.data.BuildData;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.data.ThemePack;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;
import org.spigotmc.utils.Utils;

public class DebugInfoModal
extends JFrame
implements Themeable {
    private JTextPane debugInfoTextPane;
    private JButton reportBugButton;
    private final BuildData buildData;
    private final BuildSettings buildSettings;

    public DebugInfoModal(BuildData buildData, BuildSettings buildSettings) {
        this.buildData = buildData;
        this.buildSettings = buildSettings;
        SwingUtils.applyIcon(this);
        this.initComponents();
        SwingUtils.changeTheme(this, SwingUtils.getTheme());
        this.setDefaultCloseOperation(2);
        this.setTitle("BuildTools Debug");
        this.setSize(new Dimension(600, 500));
        this.debugInfoTextPane.setCaretPosition(0);
    }

    private void initComponents() {
        JButton closeButton = new JButton("Close");
        closeButton.setMargin(new Insets(8, 16, 8, 16));
        closeButton.addActionListener(event -> this.dispose());
        this.reportBugButton = new JButton("Report a Bug");
        this.reportBugButton.setHorizontalTextPosition(2);
        this.reportBugButton.setIconTextGap(8);
        this.reportBugButton.setMargin(new Insets(8, 16, 8, 16));
        this.reportBugButton.addActionListener(event -> SwingUtils.browse("https://hub.spigotmc.org/jira/secure/Dashboard.jspa"));
        this.debugInfoTextPane = new JTextPane();
        this.debugInfoTextPane.setContentType("text/html");
        this.debugInfoTextPane.setEditable(false);
        this.debugInfoTextPane.setText(this.gatherInfo());
        JButton copyToClipboardButton = new JButton("Copy To Clipboard");
        copyToClipboardButton.setMargin(new Insets(8, 16, 8, 16));
        copyToClipboardButton.addActionListener(event -> {
            this.debugInfoTextPane.selectAll();
            this.debugInfoTextPane.copy();
            this.debugInfoTextPane.setCaretPosition(0);
            SwingUtils.buttonCooldown(copyToClipboardButton, 3, "Copied To Clipboard");
        });
        JScrollPane debugScrollPane = new JScrollPane();
        debugScrollPane.setViewportView(this.debugInfoTextPane);
        JLabel debugIconLabel = new JLabel();
        debugIconLabel.setIcon(Constants.LOGO_32x32);
        debugIconLabel.setIconTextGap(12);
        JLabel debugTitleLabel = new JLabel("<html><b>BuildTools Debug Information</b></html>");
        debugTitleLabel.setFont(new Font("Liberation Sans", 0, 14));
        JLabel bugReportLabel = new JLabel("Include the following information whenever you report a bug:");
        JPanel debugHeader = new JPanel();
        GroupLayout debugHeaderLayout = new GroupLayout(debugHeader);
        debugHeader.setLayout(debugHeaderLayout);
        debugHeaderLayout.setHorizontalGroup(debugHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugHeaderLayout.createSequentialGroup().addContainerGap().addComponent(debugIconLabel).addGap(12, 12, 12).addGroup(debugHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(debugTitleLabel, -2, -1, -2).addComponent(bugReportLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        debugHeaderLayout.setVerticalGroup(debugHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(debugHeaderLayout.createSequentialGroup().addContainerGap().addGroup(debugHeaderLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(bugReportLabel).addGroup(debugHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(debugTitleLabel, -2, -1, -2).addComponent(debugIconLabel))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(debugScrollPane).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(copyToClipboardButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportBugButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 304, Short.MAX_VALUE).addComponent(closeButton)).addComponent(debugHeader, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(debugHeader, -2, -1, -2).addGap(12, 12, 12).addComponent(debugScrollPane, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(closeButton).addComponent(copyToClipboardButton).addComponent(this.reportBugButton)).addContainerGap()));
        this.pack();
    }

    private String gatherInfo() {
        StringBuilder args = new StringBuilder();
        for (String string : this.buildSettings.getArguments()) {
            args.append(string);
            args.append(" ");
        }
        StringBuilder javaVersions = new StringBuilder();
        for (JavaInstallation installation : this.buildData.getJavaInstallationManager().getInstallations()) {
            javaVersions.append("<p>");
            if (installation.isCurrentJavaVersion()) {
                javaVersions.append("* ");
            } else {
                javaVersions.append("- ");
            }
            javaVersions.append((Object)installation.getType());
            javaVersions.append(" ");
            javaVersions.append(installation.getVersion().getMajor());
            javaVersions.append(" at ");
            javaVersions.append(installation.getJavaExecutable().getPath());
            javaVersions.append("</p>");
        }
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long totalFree = Runtime.getRuntime().maxMemory() - l;
        String memUsage = Utils.readableFileSize(l) + " / " + Utils.readableFileSize(totalFree);
        String style = Utils.getFileContentsFromResource("web/reset.css");
        String debug = Utils.getFileContentsFromResource("web/debug.html");
        debug = debug.replace("%STYLESHEET%", "<style>" + style + "</style>");
        debug = debug.replace("%BUILDTOOLS_VERSION%", Builder.class.getPackage().getImplementationVersion());
        debug = debug.replace("%JAVA_VERSION%", JavaVersion.getCurrentVersion().toString());
        debug = debug.replace("%CURRENT_PATH%", this.buildSettings.getWorkDirectory());
        debug = debug.replace("%BUILDTOOLS_FLAGS%", args);
        debug = debug.replace("%OS_NAME%", System.getProperty("os.name"));
        debug = debug.replace("%OS_ARCH%", System.getProperty("os.arch"));
        debug = debug.replace("%KERNEL_VERSION%", System.getProperty("os.version"));
        debug = debug.replace("%MEM_USAGE%", memUsage);
        debug = debug.replace("%JAVA_INSTALLATIONS%", javaVersions);
        return debug;
    }

    @Override
    public void onThemeChange(Theme theme) {
        ThemePack pack = ThemePack.fromTheme(theme);
        ImageIcon external = (ImageIcon)pack.getAsset(ThemePack.Asset.EXTERNAL);
        this.reportBugButton.setIcon(external);
    }
}

