/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.transport.PushCertificateIdent;
import org.eclipse.jgit.transport.ReceiveCommand;

public class PushCertificate {
    private final String version;
    private final PushCertificateIdent pusher;
    private final String pushee;
    private final String nonce;
    private final NonceStatus nonceStatus;
    private final List<ReceiveCommand> commands;
    private final String signature;

    public String getPusher() {
        return this.pusher.getRaw();
    }

    public String toTextWithSignature() {
        return this.toStringBuilder().append(this.signature).toString();
    }

    private StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder().append("certificate version").append(' ').append(this.version).append('\n').append("pusher").append(' ').append(this.getPusher()).append('\n');
        if (this.pushee != null) {
            sb.append("pushee").append(' ').append(this.pushee).append('\n');
        }
        sb.append("nonce").append(' ').append(this.nonce).append('\n').append('\n');
        for (ReceiveCommand cmd : this.commands) {
            sb.append(cmd.getOldId().name()).append(' ').append(cmd.getNewId().name()).append(' ').append(cmd.getRefName()).append('\n');
        }
        return sb;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PushCertificate)) {
            return false;
        }
        PushCertificate p = (PushCertificate)o;
        return this.version.equals(p.version) && this.pusher.equals(p.pusher) && Objects.equals(this.pushee, p.pushee) && this.nonceStatus == p.nonceStatus && this.signature.equals(p.signature) && PushCertificate.commandsEqual(this, p);
    }

    private static boolean commandsEqual(PushCertificate c1, PushCertificate c2) {
        if (c1.commands.size() != c2.commands.size()) {
            return false;
        }
        int i = 0;
        while (i < c1.commands.size()) {
            ReceiveCommand cmd1 = c1.commands.get(i);
            ReceiveCommand cmd2 = c2.commands.get(i);
            if (!(cmd1.getOldId().equals(cmd2.getOldId()) && cmd1.getNewId().equals(cmd2.getNewId()) && cmd1.getRefName().equals(cmd2.getRefName()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.toTextWithSignature() + ']';
    }

    public static enum NonceStatus {
        UNSOLICITED,
        BAD,
        MISSING,
        OK,
        SLOP;

    }
}

