/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class ObjectInserter
implements AutoCloseable {
    private final SHA1 hasher = SHA1.newInstance();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        byte[] b = this.tempBuffer;
        if (b == null) {
            this.tempBuffer = b = new byte[8192];
        }
        return b;
    }

    protected SHA1 digest() {
        return this.hasher.reset();
    }

    public ObjectId idFor(int type, byte[] data) {
        return this.idFor(type, data, 0, data.length);
    }

    public ObjectId idFor(int type, byte[] data, int off, int len) {
        SHA1 md = SHA1.newInstance();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        md.update(data, off, len);
        return md.toObjectId();
    }

    public final ObjectId insert(TreeFormatter formatter) throws IOException {
        return formatter.insertTo(this);
    }

    public final ObjectId insert(CommitBuilder builder) throws IOException {
        return this.insert(1, builder.build());
    }

    public ObjectId insert(int type, byte[] data) throws IOException {
        return this.insert(type, data, 0, data.length);
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        return this.insert(type, len, new ByteArrayInputStream(data, off, len));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4) throws IOException;

    public abstract PackParser newPackParser(InputStream var1) throws IOException;

    public abstract ObjectReader newReader();

    public abstract void flush() throws IOException;

    @Override
    public abstract void close();

    public static class Formatter
    extends ObjectInserter {
        @Override
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PackParser newPackParser(InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectReader newReader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() {
        }
    }
}

