/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.URIish;

public class MissingBundlePrerequisiteException
extends TransportException {
    private static String format(Map<ObjectId, String> missingCommits) {
        StringBuilder r = new StringBuilder();
        r.append(JGitText.get().missingPrerequisiteCommits);
        for (Map.Entry<ObjectId, String> e : missingCommits.entrySet()) {
            r.append("\n  ");
            r.append(e.getKey().name());
            if (e.getValue() == null) continue;
            r.append(" ").append(e.getValue());
        }
        return r.toString();
    }

    public MissingBundlePrerequisiteException(URIish uri, Map<ObjectId, String> missingCommits) {
        super(uri, MissingBundlePrerequisiteException.format(missingCommits));
    }
}

