/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels.general.console;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Lockable;
import org.spigotmc.gui.attributes.Themeable;
import org.spigotmc.gui.data.ThemePack;

public class ConsolePanelHeader
extends JPanel
implements Lockable,
Themeable {
    private JCheckBox copyLogCheckbox;

    public ConsolePanelHeader() {
        this.initComponents();
    }

    private void initComponents() {
        JLabel consoleOutputHeader = new JLabel("<html><b>Console Output</b></html>");
        this.copyLogCheckbox = new JCheckBox("Copy Log When Finished");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(consoleOutputHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.copyLogCheckbox).addGap(12, 12, 12)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(8, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(consoleOutputHeader, -2, -1, -2).addComponent(this.copyLogCheckbox)).addContainerGap()));
    }

    public boolean copyLogsOnFinish() {
        return this.copyLogCheckbox.isSelected();
    }

    @Override
    public void onLockToggle(Lockable.LockReason reason) {
        if (reason == Lockable.LockReason.START) {
            this.copyLogCheckbox.setEnabled(!this.copyLogCheckbox.isEnabled());
        }
    }

    @Override
    public void onThemeChange(Theme theme) {
        ThemePack themePack = ThemePack.fromTheme(theme);
        Color panelHeaderBackground = (Color)themePack.getAsset(ThemePack.Asset.PANEL_HEADER_BACKGROUND_COLOR);
        this.setBackground(panelHeaderBackground);
        Color broderColor = (Color)themePack.getAsset(ThemePack.Asset.BORDER_COLOR);
        this.setBorder(BorderFactory.createLineBorder(broderColor));
    }
}

