/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;

public class RemoteConfig
implements Serializable {
    private String name;
    private List<URIish> uris;
    private List<URIish> pushURIs;
    private List<RefSpec> fetch;
    private List<RefSpec> push;
    private String uploadpack;
    private String receivepack;
    private TagOpt tagopt;
    private boolean mirror;
    private int timeout;

    public RemoteConfig(Config rc, String remoteName) throws URISyntaxException {
        Map<String, String> pushInsteadOf;
        this.name = remoteName;
        String[] vlst = rc.getStringList("remote", this.name, "url");
        Map<String, String> insteadOf = this.getReplacements(rc, "insteadof");
        this.uris = new ArrayList<URIish>(vlst.length);
        String[] stringArray = vlst;
        int n = vlst.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.uris.add(new URIish(this.replaceUri(s, insteadOf)));
            ++n2;
        }
        String[] plst = rc.getStringList("remote", this.name, "pushurl");
        this.pushURIs = new ArrayList<URIish>(plst.length);
        String[] stringArray2 = plst;
        int n3 = plst.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            this.pushURIs.add(new URIish(s));
            ++n;
        }
        if (this.pushURIs.isEmpty() && !(pushInsteadOf = this.getReplacements(rc, "pushinsteadof")).isEmpty()) {
            String[] stringArray3 = vlst;
            int n4 = vlst.length;
            n3 = 0;
            while (n3 < n4) {
                String s = stringArray3[n3];
                String replaced = this.replaceUri(s, pushInsteadOf);
                if (!s.equals(replaced)) {
                    this.pushURIs.add(new URIish(replaced));
                }
                ++n3;
            }
        }
        this.fetch = rc.getRefSpecs("remote", this.name, "fetch");
        this.push = rc.getRefSpecs("remote", this.name, "push");
        String val = rc.getString("remote", this.name, "uploadpack");
        if (val == null) {
            val = "git-upload-pack";
        }
        this.uploadpack = val;
        val = rc.getString("remote", this.name, "receivepack");
        if (val == null) {
            val = "git-receive-pack";
        }
        this.receivepack = val;
        try {
            val = rc.getString("remote", this.name, "tagopt");
            this.tagopt = TagOpt.fromOption(val);
        }
        catch (IllegalArgumentException e) {
            this.tagopt = TagOpt.AUTO_FOLLOW;
        }
        this.mirror = rc.getBoolean("remote", this.name, "mirror", false);
        this.timeout = rc.getInt("remote", this.name, "timeout", 0);
    }

    public void update(Config rc) {
        ArrayList<String> vlst = new ArrayList<String>();
        vlst.clear();
        for (URIish uRIish : this.getURIs()) {
            vlst.add(uRIish.toPrivateString());
        }
        rc.setStringList("remote", this.getName(), "url", vlst);
        vlst.clear();
        for (URIish uRIish : this.getPushURIs()) {
            vlst.add(uRIish.toPrivateString());
        }
        rc.setStringList("remote", this.getName(), "pushurl", vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getFetchRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc.setStringList("remote", this.getName(), "fetch", vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getPushRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc.setStringList("remote", this.getName(), "push", vlst);
        this.set(rc, "uploadpack", this.getUploadPack(), "git-upload-pack");
        this.set(rc, "receivepack", this.getReceivePack(), "git-receive-pack");
        this.set(rc, "tagopt", this.getTagOpt().option(), TagOpt.AUTO_FOLLOW.option());
        this.set(rc, "mirror", this.mirror, false);
        this.set(rc, "timeout", this.timeout, 0);
    }

    private void set(Config rc, String key, String currentValue, String defaultValue) {
        if (defaultValue.equals(currentValue)) {
            this.unset(rc, key);
        } else {
            rc.setString("remote", this.getName(), key, currentValue);
        }
    }

    private void set(Config rc, String key, boolean currentValue, boolean defaultValue) {
        if (defaultValue == currentValue) {
            this.unset(rc, key);
        } else {
            rc.setBoolean("remote", this.getName(), key, currentValue);
        }
    }

    private void set(Config rc, String key, int currentValue, int defaultValue) {
        if (defaultValue == currentValue) {
            this.unset(rc, key);
        } else {
            rc.setInt("remote", this.getName(), key, currentValue);
        }
    }

    private void unset(Config rc, String key) {
        rc.unset("remote", this.getName(), key);
    }

    private Map<String, String> getReplacements(Config config, String keyName) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (String url : config.getSubsections("url")) {
            String[] stringArray = config.getStringList("url", url, keyName);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String insteadOf = stringArray[n2];
                replacements.put(insteadOf, url);
                ++n2;
            }
        }
        return replacements;
    }

    private String replaceUri(String uri, Map<String, String> replacements) {
        if (replacements.isEmpty()) {
            return uri;
        }
        Map.Entry<String, String> match = null;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (match != null && ((String)match.getKey()).length() > replacement.getKey().length() || !uri.startsWith(replacement.getKey())) continue;
            match = replacement;
        }
        if (match != null) {
            return String.valueOf((String)match.getValue()) + uri.substring(((String)match.getKey()).length());
        }
        return uri;
    }

    public String getName() {
        return this.name;
    }

    public List<URIish> getURIs() {
        return Collections.unmodifiableList(this.uris);
    }

    public boolean addURI(URIish toAdd) {
        if (this.uris.contains(toAdd)) {
            return false;
        }
        return this.uris.add(toAdd);
    }

    public List<URIish> getPushURIs() {
        return Collections.unmodifiableList(this.pushURIs);
    }

    public List<RefSpec> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetch);
    }

    public void setFetchRefSpecs(List<RefSpec> specs) {
        this.fetch.clear();
        this.fetch.addAll(specs);
    }

    public List<RefSpec> getPushRefSpecs() {
        return Collections.unmodifiableList(this.push);
    }

    public String getUploadPack() {
        return this.uploadpack;
    }

    public String getReceivePack() {
        return this.receivepack;
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    public void setMirror(boolean m) {
        this.mirror = m;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

