/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;

public abstract class OperationResult {
    Map<String, Ref> advertisedRefs = Collections.emptyMap();
    URIish uri;
    final SortedMap<String, TrackingRefUpdate> updates = new TreeMap<String, TrackingRefUpdate>();
    StringBuilder messageBuffer;
    String peerUserAgent;

    public Collection<Ref> getAdvertisedRefs() {
        return Collections.unmodifiableCollection(this.advertisedRefs.values());
    }

    public final Ref getAdvertisedRef(String name) {
        return this.advertisedRefs.get(name);
    }

    public Collection<TrackingRefUpdate> getTrackingRefUpdates() {
        return Collections.unmodifiableCollection(this.updates.values());
    }

    void setAdvertisedRefs(URIish u, Map<String, Ref> ar) {
        this.uri = u;
        this.advertisedRefs = ar;
    }

    void add(TrackingRefUpdate u) {
        this.updates.put(u.getLocalName(), u);
    }

    void addMessages(String msg) {
        if (msg != null && msg.length() > 0) {
            if (this.messageBuffer == null) {
                this.messageBuffer = new StringBuilder();
            }
            this.messageBuffer.append(msg);
            if (!msg.endsWith("\n")) {
                this.messageBuffer.append('\n');
            }
        }
    }
}

