/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class RevTag
extends RevObject {
    private static final byte[] hSignature = Constants.encodeASCII("-----BEGIN PGP SIGNATURE-----");
    private RevObject object;
    private byte[] buffer;
    private String tagName;

    protected RevTag(AnyObjectId id) {
        super(id);
    }

    @Override
    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk, walk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk, byte[] rawTag) throws CorruptObjectException {
        MutableInteger pos = new MutableInteger();
        pos.value = 53;
        int oType = Constants.decodeTypeString(this, rawTag, (byte)10, pos);
        walk.idBuffer.fromString(rawTag, 7);
        this.object = walk.lookupAny(walk.idBuffer, oType);
        int p = pos.value += 4;
        int nameEnd = RawParseUtils.nextLF(rawTag, p) - 1;
        this.tagName = RawParseUtils.decode(StandardCharsets.UTF_8, rawTag, p, nameEnd);
        if (walk.isRetainBody()) {
            this.buffer = rawTag;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 4;
    }

    public final RevObject getObject() {
        return this.object;
    }
}

