/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.nls.GlobalBundleCache;
import org.eclipse.jgit.nls.TranslationBundle;

public class NLS {
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static final InheritableThreadLocal<NLS> local = new InheritableThreadLocal();
    private final Locale locale;
    private final Map<Class, TranslationBundle> map = new ConcurrentHashMap<Class, TranslationBundle>();

    private static NLS useJVMDefaultInternal() {
        NLS b = new NLS(Locale.getDefault());
        local.set(b);
        return b;
    }

    public static <T extends TranslationBundle> T getBundleFor(Class<T> type) {
        NLS b = (NLS)local.get();
        if (b == null) {
            b = NLS.useJVMDefaultInternal();
        }
        return b.get(type);
    }

    private NLS(Locale locale) {
        this.locale = locale;
    }

    private <T extends TranslationBundle> T get(Class<T> type) {
        TranslationBundle old;
        TranslationBundle bundle = this.map.get(type);
        if (bundle == null && (old = this.map.putIfAbsent(type, bundle = GlobalBundleCache.lookupBundle(this.locale, type))) != null) {
            bundle = old;
        }
        return (T)bundle;
    }
}

