/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.MutableInteger;

public final class Constants {
    private static final byte[] ENCODED_TYPE_COMMIT = Constants.encodeASCII("commit");
    private static final byte[] ENCODED_TYPE_BLOB = Constants.encodeASCII("blob");
    private static final byte[] ENCODED_TYPE_TREE = Constants.encodeASCII("tree");
    private static final byte[] ENCODED_TYPE_TAG = Constants.encodeASCII("tag");
    public static final byte[] PACK_SIGNATURE = new byte[]{80, 65, 67, 75};
    @Deprecated
    public static final Charset CHARSET;
    @Deprecated
    public static final String CHARACTER_ENCODING;
    public static final ObjectId EMPTY_BLOB_ID;
    public static final ObjectId EMPTY_TREE_ID;

    static {
        if (20 != Constants.newMessageDigest().getDigestLength()) {
            throw new LinkageError(JGitText.get().incorrectOBJECT_ID_LENGTH);
        }
        CHARSET = StandardCharsets.UTF_8;
        CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
        EMPTY_BLOB_ID = ObjectId.fromString("e69de29bb2d1d6434b8b29ae775ad8c2e48c5391");
        EMPTY_TREE_ID = ObjectId.fromString("4b825dc642cb6eb9a060e54bf8d69288fbee4904");
    }

    public static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(MessageFormat.format(JGitText.get().requiredHashFunctionNotAvailable, "SHA-1"), nsae);
        }
    }

    public static String typeString(int typeCode) {
        switch (typeCode) {
            case 1: {
                return "commit";
            }
            case 2: {
                return "tree";
            }
            case 3: {
                return "blob";
            }
            case 4: {
                return "tag";
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, typeCode));
    }

    public static byte[] encodedTypeString(int typeCode) {
        switch (typeCode) {
            case 1: {
                return ENCODED_TYPE_COMMIT;
            }
            case 2: {
                return ENCODED_TYPE_TREE;
            }
            case 3: {
                return ENCODED_TYPE_BLOB;
            }
            case 4: {
                return ENCODED_TYPE_TAG;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, typeCode));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int decodeTypeString(AnyObjectId id, byte[] typeString, byte endMark, MutableInteger offset) throws CorruptObjectException {
        try {
            int position = offset.value;
            switch (typeString[position]) {
                case 98: {
                    if (typeString[position + 1] == 108 && typeString[position + 2] == 111 && typeString[position + 3] == 98 && typeString[position + 4] == endMark) {
                        offset.value = position + 5;
                        return 3;
                    }
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                }
                case 99: {
                    if (typeString[position + 1] == 111 && typeString[position + 2] == 109 && typeString[position + 3] == 109 && typeString[position + 4] == 105 && typeString[position + 5] == 116 && typeString[position + 6] == endMark) {
                        offset.value = position + 7;
                        return 1;
                    }
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                }
                case 116: {
                    switch (typeString[position + 1]) {
                        case 97: {
                            if (typeString[position + 2] == 103 && typeString[position + 3] == endMark) {
                                offset.value = position + 4;
                                return 4;
                            }
                            throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                        }
                        case 114: {
                            if (typeString[position + 2] == 101 && typeString[position + 3] == 101 && typeString[position + 4] == endMark) {
                                offset.value = position + 5;
                                return 2;
                            }
                            throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                        }
                    }
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                }
            }
            throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
        }
        catch (ArrayIndexOutOfBoundsException bad) {
            CorruptObjectException coe = new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
            coe.initCause(bad);
            throw coe;
        }
    }

    public static byte[] encodeASCII(long s) {
        return Constants.encodeASCII(Long.toString(s));
    }

    public static byte[] encodeASCII(String s) {
        byte[] r = new byte[s.length()];
        int k = r.length - 1;
        while (k >= 0) {
            char c = s.charAt(k);
            if (c > '\u007f') {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notASCIIString, s));
            }
            r[k] = (byte)c;
            --k;
        }
        return r;
    }

    public static byte[] encode(String str) {
        byte[] arr;
        ByteBuffer bb = StandardCharsets.UTF_8.encode(str);
        int len = bb.limit();
        if (bb.hasArray() && bb.arrayOffset() == 0 && (arr = bb.array()).length == len) {
            return arr;
        }
        arr = new byte[len];
        bb.get(arr);
        return arr;
    }
}

