/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class CheckoutConflictException
extends IOException {
    private final String[] conflicting;

    public CheckoutConflictException(String file) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFile, file));
        this.conflicting = new String[]{file};
    }

    public CheckoutConflictException(String[] files) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFiles, CheckoutConflictException.buildList(files)));
        this.conflicting = files;
    }

    private static String buildList(String[] files) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            builder.append("\n");
            builder.append(f);
            ++n2;
        }
        return builder.toString();
    }
}

