/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.StandardDeleteOption;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    public static Counters.PathCounters delete(Path path, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return Files.isDirectory(path, linkOptions) ? PathUtils.deleteDirectory(path, linkOptions, deleteOptions) : PathUtils.deleteFile(path, linkOptions, deleteOptions);
    }

    public static Counters.PathCounters deleteDirectory(Path directory, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws IOException {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptions, deleteOptions, new String[0]), directory).getPathCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters.PathCounters deleteFile(Path file, LinkOption[] linkOptions, DeleteOption ... deleteOptions) throws NoSuchFileException, IOException {
        if (Files.isDirectory(file, linkOptions)) {
            throw new NoSuchFileException(file.toString());
        }
        Counters.PathCounters pathCounts = Counters.longPathCounters();
        boolean exists = PathUtils.exists(file, linkOptions);
        long size = exists && !Files.isSymbolicLink(file) ? Files.size(file) : 0L;
        try {
            if (Files.deleteIfExists(file)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size);
                return pathCounts;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(file);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptions)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(parent, linkOptions);
                PathUtils.setReadOnly(file, false, linkOptions);
            }
            long l = size = (exists = PathUtils.exists(file, linkOptions)) && !Files.isSymbolicLink(file) ? Files.size(file) : 0L;
            if (Files.deleteIfExists(file)) {
                pathCounts.getFileCounter().increment();
                pathCounts.getByteCounter().add(size);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(parent, posixFileAttributes.permissions());
            }
        }
        return pathCounts;
    }

    private static boolean exists(Path path, LinkOption ... options) {
        Objects.requireNonNull(path, "path");
        return options != null ? Files.exists(path, options) : Files.exists(path, new LinkOption[0]);
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path, LinkOption ... options) {
        return Files.getFileAttributeView(path, DosFileAttributeView.class, options);
    }

    private static Path getParent(Path path) {
        return path == null ? null : path.getParent();
    }

    public static boolean isEmptyDirectory(Path directory) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isPosix(Path test, LinkOption ... options) {
        return PathUtils.exists(test, options) && PathUtils.readPosixFileAttributes(test, options) != null;
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptions) {
        if (deleteOptions == null) {
            return false;
        }
        return Stream.of(deleteOptions).anyMatch(e -> e == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) {
        try {
            return path == null ? null : (A)Files.readAttributes(path, type, options);
        }
        catch (IOException | UnsupportedOperationException e) {
            return null;
        }
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path, LinkOption ... options) {
        return PathUtils.readAttributes(path, PosixFileAttributes.class, options);
    }

    private static boolean setDosReadOnly(Path path, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        DosFileAttributeView dosFileAttributeView = PathUtils.getDosFileAttributeView(path, linkOptions);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(readOnly);
            return true;
        }
        return false;
    }

    private static boolean setPosixDeletePermissions(Path parent, boolean enableDeleteChildren, LinkOption ... linkOptions) throws IOException {
        return PathUtils.setPosixPermissions(parent, enableDeleteChildren, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptions);
    }

    private static boolean setPosixPermissions(Path path, boolean addPermissions, List<PosixFilePermission> updatePermissions, LinkOption ... linkOptions) throws IOException {
        if (path != null) {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, linkOptions);
            if (addPermissions) {
                permissions.addAll(updatePermissions);
            } else {
                permissions.removeAll(updatePermissions);
            }
            Files.setPosixFilePermissions(path, permissions);
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, linkOptions);
        List<PosixFilePermission> readPermissions = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> writePermissions = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (readOnly) {
            permissions.addAll(readPermissions);
            permissions.removeAll(writePermissions);
        } else {
            permissions.addAll(readPermissions);
            permissions.addAll(writePermissions);
        }
        Files.setPosixFilePermissions(path, permissions);
    }

    public static Path setReadOnly(Path path, boolean readOnly, LinkOption ... linkOptions) throws IOException {
        try {
            if (PathUtils.setDosReadOnly(path, readOnly, linkOptions)) {
                return path;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path parent = PathUtils.getParent(path);
        if (!PathUtils.isPosix(parent, linkOptions)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s' %s", path, Arrays.toString(linkOptions)));
        }
        if (readOnly) {
            PathUtils.setPosixReadOnlyFile(path, readOnly, linkOptions);
            PathUtils.setPosixDeletePermissions(parent, false, linkOptions);
        } else {
            PathUtils.setPosixDeletePermissions(parent, true, linkOptions);
        }
        return path;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T visitor, Path directory) throws IOException {
        Files.walkFileTree(directory, visitor);
        return visitor;
    }
}

