/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOConsumer;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int size) {
        return new char[size];
    }

    public static void close(Closeable closeable, IOConsumer<IOException> consumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    public static int length(byte[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(Object[] array) {
        return array == null ? 0 : array.length;
    }
}

