/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.javafinder;

import com.jeff_media.javafinder.JavaType;
import com.jeff_media.javafinder.JavaVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInstallation
implements Comparable<JavaInstallation> {
    @NotNull
    private final File homeDirectory;
    @NotNull
    private final File javaExecutable;
    @Nullable
    private final File javacExecutable;
    @NotNull
    private final JavaVersion version;
    @NotNull
    private final JavaType type;
    private final boolean isCurrentJavaVersion;

    public JavaInstallation(@NotNull File homeDirectory, @NotNull File javaExecutable, @Nullable File javaxExecutable, @NotNull JavaType type) throws IOException {
        this.homeDirectory = homeDirectory;
        this.javaExecutable = javaExecutable;
        this.javacExecutable = javaxExecutable;
        this.type = type;
        this.version = JavaVersion.fromJavaVersionOutput(this.captureJavaVersionOutput());
        String currentJavaHome = System.getProperty("java.home");
        this.isCurrentJavaVersion = currentJavaHome != null ? currentJavaHome.equals(homeDirectory.getAbsolutePath()) : false;
    }

    private List<String> captureJavaVersionOutput() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.javaExecutable.getAbsolutePath(), "-version");
        ArrayList<String> completeVersionOutput = new ArrayList<String>();
        Process process = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                completeVersionOutput.add(line);
            }
        }
        return completeVersionOutput;
    }

    @Override
    public int compareTo(JavaInstallation o) {
        int result = this.version.compareTo(o.version);
        if (result != 0) {
            return result;
        }
        return this.type.compareTo(o.type);
    }

    @NotNull
    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    @NotNull
    public File getJavaExecutable() {
        return this.javaExecutable;
    }

    @NotNull
    public JavaVersion getVersion() {
        return this.version;
    }

    @NotNull
    public JavaType getType() {
        return this.type;
    }

    public boolean isCurrentJavaVersion() {
        return this.isCurrentJavaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaInstallation)) {
            return false;
        }
        JavaInstallation other = (JavaInstallation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$homeDirectory = this.getHomeDirectory();
        File other$homeDirectory = other.getHomeDirectory();
        if (this$homeDirectory == null ? other$homeDirectory != null : !((Object)this$homeDirectory).equals(other$homeDirectory)) {
            return false;
        }
        File this$executable = this.getJavaExecutable();
        File other$executable = other.getJavaExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        JavaVersion this$version = this.getVersion();
        JavaVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        JavaType this$type = this.getType();
        JavaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return this.isCurrentJavaVersion() == other.isCurrentJavaVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaInstallation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $homeDirectory = this.getHomeDirectory();
        result = result * 59 + ($homeDirectory == null ? 43 : ((Object)$homeDirectory).hashCode());
        File $executable = this.getJavaExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        JavaVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        JavaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + (this.isCurrentJavaVersion() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JavaInstallation(homeDirectory=" + this.getHomeDirectory() + ", executable=" + this.getJavaExecutable() + ", version=" + this.getVersion() + ", type=" + (Object)((Object)this.getType()) + ", isCurrentJavaVersion=" + this.isCurrentJavaVersion() + ")";
    }
}

