/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.javafinder;

import com.jeff_media.javafinder.DirectoryCrawler;
import com.jeff_media.javafinder.JavaFinderBuilder;
import com.jeff_media.javafinder.JavaInstallation;
import com.jeff_media.javafinder.OperatingSystem;
import com.jeff_media.javafinder.ProgramFilesFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaFinder {
    private final Set<File> searchDirectories = new HashSet<File>();

    JavaFinder(Collection<File> searchDirectories) {
        this.searchDirectories.addAll(searchDirectories);
        searchDirectories.removeIf(file -> file == null || !file.isDirectory());
        Collection<File> locationsCopy = Collections.unmodifiableCollection(searchDirectories);
        searchDirectories.removeIf(file -> {
            for (File other : locationsCopy) {
                if (other.equals(file) || !file.getAbsolutePath().startsWith(other.getAbsolutePath() + File.separator)) continue;
                return true;
            }
            return false;
        });
    }

    public static JavaFinderBuilder builder() {
        return new JavaFinderBuilder();
    }

    static Set<File> getDefaultJavaLocations() {
        File userHomeFile;
        HashSet<File> locations = new HashSet<File>();
        String userHome = System.getProperty("user.home");
        File currentJavaHome = new File(System.getProperty("java.home"));
        File parentOfCurrentJavaHome = currentJavaHome.getParentFile();
        if (!parentOfCurrentJavaHome.equals(userHomeFile = new File(userHome))) {
            locations.add(currentJavaHome.getParentFile());
        }
        locations.add(currentJavaHome);
        locations.add(new File(userHomeFile, ".jdks"));
        if (userHome != null) {
            locations.add(new File(userHome, String.join((CharSequence)File.separator, ".sdkman", "candidates", "java")));
        }
        switch (OperatingSystem.CURRENT) {
            case WINDOWS: {
                JavaFinder.addProgramFilesSubdir(locations, "Java");
                JavaFinder.addProgramFilesSubdir(locations, "Eclipse Foundation");
                JavaFinder.addProgramFilesSubdir(locations, "Eclipse Adoptium");
                JavaFinder.addProgramFilesSubdirs(locations, ProgramFilesFileFilter.INSTANCE);
                break;
            }
            case LINUX: {
                locations.add(new File("/usr/lib/jvm"));
                break;
            }
            case MACOS: {
                locations.add(new File("/Library/Java/JavaVirtualMachines"));
                locations.add(new File("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home"));
                if (userHome == null) break;
                locations.add(new File(userHome, "Library/Java/JavaVirtualMachines"));
                break;
            }
        }
        return locations;
    }

    private static void addProgramFilesSubdir(Collection<File> locations, String name) {
        String programFiles = System.getenv("ProgramFiles");
        String programFilesX86 = System.getenv("ProgramFiles(x86)");
        if (programFiles != null) {
            JavaFinder.addFolderIfExists(locations, new File(programFiles, name));
        }
        if (programFilesX86 != null) {
            JavaFinder.addFolderIfExists(locations, new File(programFilesX86, name));
        }
    }

    private static void addProgramFilesSubdirs(Collection<File> locations, FileFilter predicate) {
        String programFiles = System.getenv("ProgramFiles");
        String programFilesX86 = System.getenv("ProgramFiles(x86)");
        if (programFiles != null) {
            JavaFinder.addSubdirs(locations, new File(programFiles), predicate);
        }
        if (programFilesX86 != null) {
            JavaFinder.addSubdirs(locations, new File(programFilesX86), predicate);
        }
    }

    private static void addSubdirs(Collection<File> locations, File folder, FileFilter predicate) {
        if (folder.isDirectory()) {
            try {
                for (File subdir : Objects.requireNonNull(folder.listFiles(predicate))) {
                    JavaFinder.addFolderIfExists(locations, subdir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addFolderIfExists(Collection<File> locations, File file) {
        if (locations.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            locations.add(file);
        }
    }

    @Deprecated
    @NotNull
    public List<JavaInstallation> findInstallations() {
        HashSet<JavaInstallation> installations = new HashSet<JavaInstallation>();
        for (File location : this.searchDirectories) {
            if (!location.isDirectory()) continue;
            installations.addAll(new DirectoryCrawler(location, OperatingSystem.CURRENT).findInstallations());
        }
        return installations.stream().sorted().collect(Collectors.toList());
    }
}

